/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of IP access settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAccessSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IpAccessSettingsSummary.Builder, IpAccessSettingsSummary> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(IpAccessSettingsSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IpAccessSettingsSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(IpAccessSettingsSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAccessSettingsArn").getter(getter(IpAccessSettingsSummary::ipAccessSettingsArn))
            .setter(setter(Builder::ipAccessSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("creationDate", CREATION_DATE_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("displayName", DISPLAY_NAME_FIELD);
                    put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant creationDate;

    private final String description;

    private final String displayName;

    private final String ipAccessSettingsArn;

    private IpAccessSettingsSummary(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
    }

    /**
     * <p>
     * The creation date timestamp of the IP access settings.
     * </p>
     * 
     * @return The creation date timestamp of the IP access settings.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     * 
     * @return The description of the IP access settings.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     * 
     * @return The display name of the IP access settings.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The ARN of IP access settings.
     * </p>
     * 
     * @return The ARN of IP access settings.
     */
    public final String ipAccessSettingsArn() {
        return ipAccessSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettingsSummary)) {
            return false;
        }
        IpAccessSettingsSummary other = (IpAccessSettingsSummary) obj;
        return Objects.equals(creationDate(), other.creationDate()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(ipAccessSettingsArn(), other.ipAccessSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAccessSettingsSummary").add("CreationDate", creationDate())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IpAccessSettingsArn", ipAccessSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ipAccessSettingsArn":
            return Optional.ofNullable(clazz.cast(ipAccessSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IpAccessSettingsSummary, T> g) {
        return obj -> g.apply((IpAccessSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAccessSettingsSummary> {
        /**
         * <p>
         * The creation date timestamp of the IP access settings.
         * </p>
         * 
         * @param creationDate
         *        The creation date timestamp of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The description of the IP access settings.
         * </p>
         * 
         * @param description
         *        The description of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the IP access settings.
         * </p>
         * 
         * @param displayName
         *        The display name of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The ARN of IP access settings.
         * </p>
         * 
         * @param ipAccessSettingsArn
         *        The ARN of IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettingsArn(String ipAccessSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDate;

        private String description;

        private String displayName;

        private String ipAccessSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAccessSettingsSummary model) {
            creationDate(model.creationDate);
            description(model.description);
            displayName(model.displayName);
            ipAccessSettingsArn(model.ipAccessSettingsArn);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        @Override
        public IpAccessSettingsSummary build() {
            return new IpAccessSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
