/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<ListSessionsRequest.Builder, ListSessionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSessionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(ListSessionsRequest::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(ListSessionsRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sessionId").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListSessionsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListSessionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(ListSessionsRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PORTAL_ID_FIELD, SESSION_ID_FIELD, SORT_BY_FIELD, STATUS_FIELD, USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("portalId", PORTAL_ID_FIELD);
                    put("sessionId", SESSION_ID_FIELD);
                    put("sortBy", SORT_BY_FIELD);
                    put("status", STATUS_FIELD);
                    put("username", USERNAME_FIELD);
                }
            });

    private final Integer maxResults;

    private final String nextToken;

    private final String portalId;

    private final String sessionId;

    private final String sortBy;

    private final String status;

    private final String username;

    private ListSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.portalId = builder.portalId;
        this.sessionId = builder.sessionId;
        this.sortBy = builder.sortBy;
        this.status = builder.status;
        this.username = builder.username;
    }

    /**
     * <p>
     * The maximum number of results to be included in the next page.
     * </p>
     * 
     * @return The maximum number of results to be included in the next page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the web portal for the sessions.
     * </p>
     * 
     * @return The ID of the web portal for the sessions.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The method in which the returned sessions should be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SessionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The method in which the returned sessions should be sorted.
     * @see SessionSortBy
     */
    public final SessionSortBy sortBy() {
        return SessionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The method in which the returned sessions should be sorted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SessionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The method in which the returned sessions should be sorted.
     * @see SessionSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session.
     * @see SessionStatus
     */
    public final SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session.
     * @see SessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The username of the session.
     * </p>
     * 
     * @return The username of the session.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsRequest)) {
            return false;
        }
        ListSessionsRequest other = (ListSessionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(portalId(), other.portalId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("PortalId", portalId()).add("SessionId", sessionId()).add("SortBy", sortByAsString())
                .add("Status", statusAsString()).add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsRequest, T> g) {
        return obj -> g.apply((ListSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSessionsRequest> {
        /**
         * <p>
         * The maximum number of results to be included in the next page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be included in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the web portal for the sessions.
         * </p>
         * 
         * @param portalId
         *        The ID of the web portal for the sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The method in which the returned sessions should be sorted.
         * </p>
         * 
         * @param sortBy
         *        The method in which the returned sessions should be sorted.
         * @see SessionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The method in which the returned sessions should be sorted.
         * </p>
         * 
         * @param sortBy
         *        The method in which the returned sessions should be sorted.
         * @see SessionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionSortBy
         */
        Builder sortBy(SessionSortBy sortBy);

        /**
         * <p>
         * The status of the session.
         * </p>
         * 
         * @param status
         *        The status of the session.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the session.
         * </p>
         * 
         * @param status
         *        The status of the session.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * The username of the session.
         * </p>
         * 
         * @param username
         *        The username of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String portalId;

        private String sessionId;

        private String sortBy;

        private String status;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            portalId(model.portalId);
            sessionId(model.sessionId);
            sortBy(model.sortBy);
            status(model.status);
            username(model.username);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPortalId() {
            return portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SessionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSessionsRequest build() {
            return new ListSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
