/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserAccessLoggingSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateUserAccessLoggingSettingsRequest.Builder, UpdateUserAccessLoggingSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateUserAccessLoggingSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kinesisStreamArn").getter(getter(UpdateUserAccessLoggingSettingsRequest::kinesisStreamArn))
            .setter(setter(Builder::kinesisStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesisStreamArn").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(UpdateUserAccessLoggingSettingsRequest::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            KINESIS_STREAM_ARN_FIELD, USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("kinesisStreamArn", KINESIS_STREAM_ARN_FIELD);
                    put("userAccessLoggingSettingsArn", USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD);
                }
            });

    private final String clientToken;

    private final String kinesisStreamArn;

    private final String userAccessLoggingSettingsArn;

    private UpdateUserAccessLoggingSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.kinesisStreamArn = builder.kinesisStreamArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @return The ARN of the Kinesis stream.
     */
    public final String kinesisStreamArn() {
        return kinesisStreamArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @return The ARN of the user access logging settings.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAccessLoggingSettingsRequest)) {
            return false;
        }
        UpdateUserAccessLoggingSettingsRequest other = (UpdateUserAccessLoggingSettingsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(kinesisStreamArn(), other.kinesisStreamArn())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserAccessLoggingSettingsRequest").add("ClientToken", clientToken())
                .add("KinesisStreamArn", kinesisStreamArn()).add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "kinesisStreamArn":
            return Optional.ofNullable(clazz.cast(kinesisStreamArn()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserAccessLoggingSettingsRequest, T> g) {
        return obj -> g.apply((UpdateUserAccessLoggingSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserAccessLoggingSettingsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN of the Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamArn
         *        The ARN of the Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamArn(String kinesisStreamArn);

        /**
         * <p>
         * The ARN of the user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String kinesisStreamArn;

        private String userAccessLoggingSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAccessLoggingSettingsRequest model) {
            super(model);
            clientToken(model.clientToken);
            kinesisStreamArn(model.kinesisStreamArn);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getKinesisStreamArn() {
            return kinesisStreamArn;
        }

        public final void setKinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
        }

        @Override
        public final Builder kinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserAccessLoggingSettingsRequest build() {
            return new UpdateUserAccessLoggingSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
