/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserAccessLoggingSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<UpdateUserAccessLoggingSettingsResponse.Builder, UpdateUserAccessLoggingSettingsResponse> {
    private static final SdkField<UserAccessLoggingSettings> USER_ACCESS_LOGGING_SETTINGS_FIELD = SdkField
            .<UserAccessLoggingSettings> builder(MarshallingType.SDK_POJO).memberName("userAccessLoggingSettings")
            .getter(getter(UpdateUserAccessLoggingSettingsResponse::userAccessLoggingSettings))
            .setter(setter(Builder::userAccessLoggingSettings)).constructor(UserAccessLoggingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_ACCESS_LOGGING_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("userAccessLoggingSettings", USER_ACCESS_LOGGING_SETTINGS_FIELD);
                }
            });

    private final UserAccessLoggingSettings userAccessLoggingSettings;

    private UpdateUserAccessLoggingSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.userAccessLoggingSettings = builder.userAccessLoggingSettings;
    }

    /**
     * <p>
     * The user access logging settings.
     * </p>
     * 
     * @return The user access logging settings.
     */
    public final UserAccessLoggingSettings userAccessLoggingSettings() {
        return userAccessLoggingSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAccessLoggingSettingsResponse)) {
            return false;
        }
        UpdateUserAccessLoggingSettingsResponse other = (UpdateUserAccessLoggingSettingsResponse) obj;
        return Objects.equals(userAccessLoggingSettings(), other.userAccessLoggingSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserAccessLoggingSettingsResponse")
                .add("UserAccessLoggingSettings", userAccessLoggingSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAccessLoggingSettings":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserAccessLoggingSettingsResponse, T> g) {
        return obj -> g.apply((UpdateUserAccessLoggingSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserAccessLoggingSettingsResponse> {
        /**
         * <p>
         * The user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettings
         *        The user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettings(UserAccessLoggingSettings userAccessLoggingSettings);

        /**
         * <p>
         * The user access logging settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserAccessLoggingSettings.Builder}
         * avoiding the need to create one manually via {@link UserAccessLoggingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserAccessLoggingSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #userAccessLoggingSettings(UserAccessLoggingSettings)}.
         * 
         * @param userAccessLoggingSettings
         *        a consumer that will call methods on {@link UserAccessLoggingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAccessLoggingSettings(UserAccessLoggingSettings)
         */
        default Builder userAccessLoggingSettings(Consumer<UserAccessLoggingSettings.Builder> userAccessLoggingSettings) {
            return userAccessLoggingSettings(UserAccessLoggingSettings.builder().applyMutation(userAccessLoggingSettings).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private UserAccessLoggingSettings userAccessLoggingSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAccessLoggingSettingsResponse model) {
            super(model);
            userAccessLoggingSettings(model.userAccessLoggingSettings);
        }

        public final UserAccessLoggingSettings.Builder getUserAccessLoggingSettings() {
            return userAccessLoggingSettings != null ? userAccessLoggingSettings.toBuilder() : null;
        }

        public final void setUserAccessLoggingSettings(UserAccessLoggingSettings.BuilderImpl userAccessLoggingSettings) {
            this.userAccessLoggingSettings = userAccessLoggingSettings != null ? userAccessLoggingSettings.build() : null;
        }

        @Override
        public final Builder userAccessLoggingSettings(UserAccessLoggingSettings userAccessLoggingSettings) {
            this.userAccessLoggingSettings = userAccessLoggingSettings;
            return this;
        }

        @Override
        public UpdateUserAccessLoggingSettingsResponse build() {
            return new UpdateUserAccessLoggingSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
