/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateIpAccessSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<AssociateIpAccessSettingsResponse.Builder, AssociateIpAccessSettingsResponse> {
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAccessSettingsArn").getter(getter(AssociateIpAccessSettingsResponse::ipAccessSettingsArn))
            .setter(setter(Builder::ipAccessSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build())
            .build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(AssociateIpAccessSettingsResponse::portalArn))
            .setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ACCESS_SETTINGS_ARN_FIELD,
            PORTAL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
                    put("portalArn", PORTAL_ARN_FIELD);
                }
            });

    private final String ipAccessSettingsArn;

    private final String portalArn;

    private AssociateIpAccessSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.portalArn = builder.portalArn;
    }

    /**
     * <p>
     * The ARN of the IP access settings resource.
     * </p>
     * 
     * @return The ARN of the IP access settings resource.
     */
    public final String ipAccessSettingsArn() {
        return ipAccessSettingsArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIpAccessSettingsResponse)) {
            return false;
        }
        AssociateIpAccessSettingsResponse other = (AssociateIpAccessSettingsResponse) obj;
        return Objects.equals(ipAccessSettingsArn(), other.ipAccessSettingsArn())
                && Objects.equals(portalArn(), other.portalArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateIpAccessSettingsResponse").add("IpAccessSettingsArn", ipAccessSettingsArn())
                .add("PortalArn", portalArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAccessSettingsArn":
            return Optional.ofNullable(clazz.cast(ipAccessSettingsArn()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateIpAccessSettingsResponse, T> g) {
        return obj -> g.apply((AssociateIpAccessSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateIpAccessSettingsResponse> {
        /**
         * <p>
         * The ARN of the IP access settings resource.
         * </p>
         * 
         * @param ipAccessSettingsArn
         *        The ARN of the IP access settings resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettingsArn(String ipAccessSettingsArn);

        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private String ipAccessSettingsArn;

        private String portalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIpAccessSettingsResponse model) {
            super(model);
            ipAccessSettingsArn(model.ipAccessSettingsArn);
            portalArn(model.portalArn);
        }

        public final String getIpAccessSettingsArn() {
            return ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        @Override
        public AssociateIpAccessSettingsResponse build() {
            return new AssociateIpAccessSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
