/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The browser settings resource that can be associated with a web portal. Once associated with a web portal, browser
 * settings control how the browser will behave once a user starts a streaming session for the web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrowserSettings implements SdkPojo, Serializable, ToCopyableBuilder<BrowserSettings.Builder, BrowserSettings> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(BrowserSettings::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(BrowserSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserPolicy").getter(getter(BrowserSettings::browserPolicy)).setter(setter(Builder::browserPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()).build();

    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(BrowserSettings::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build())
            .build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(BrowserSettings::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, BROWSER_POLICY_FIELD, BROWSER_SETTINGS_ARN_FIELD,
            CUSTOMER_MANAGED_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
                    put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
                    put("browserPolicy", BROWSER_POLICY_FIELD);
                    put("browserSettingsArn", BROWSER_SETTINGS_ARN_FIELD);
                    put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, String> additionalEncryptionContext;

    private final List<String> associatedPortalArns;

    private final String browserPolicy;

    private final String browserSettingsArn;

    private final String customerManagedKey;

    private BrowserSettings(BuilderImpl builder) {
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.browserPolicy = builder.browserPolicy;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.customerManagedKey = builder.customerManagedKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the browser settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the browser settings.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this browser settings is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this browser settings is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @return A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */
    public final String browserPolicy() {
        return browserPolicy;
    }

    /**
     * <p>
     * The ARN of the browser settings.
     * </p>
     * 
     * @return The ARN of the browser settings.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    /**
     * <p>
     * The customer managed key used to encrypt sensitive information in the browser settings.
     * </p>
     * 
     * @return The customer managed key used to encrypt sensitive information in the browser settings.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSettings)) {
            return false;
        }
        BrowserSettings other = (BrowserSettings) obj;
        return hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(browserPolicy(), other.browserPolicy())
                && Objects.equals(browserSettingsArn(), other.browserSettingsArn())
                && Objects.equals(customerManagedKey(), other.customerManagedKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrowserSettings")
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("BrowserPolicy", browserPolicy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BrowserSettingsArn", browserSettingsArn()).add("CustomerManagedKey", customerManagedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "browserPolicy":
            return Optional.ofNullable(clazz.cast(browserPolicy()));
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BrowserSettings, T> g) {
        return obj -> g.apply((BrowserSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrowserSettings> {
        /**
         * <p>
         * The additional encryption context of the browser settings.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * A list of web portal ARNs that this browser settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this browser settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this browser settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this browser settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * </p>
         * 
         * @param browserPolicy
         *        A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserPolicy(String browserPolicy);

        /**
         * <p>
         * The ARN of the browser settings.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);

        /**
         * <p>
         * The customer managed key used to encrypt sensitive information in the browser settings.
         * </p>
         * 
         * @param customerManagedKey
         *        The customer managed key used to encrypt sensitive information in the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private String browserPolicy;

        private String browserSettingsArn;

        private String customerManagedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSettings model) {
            additionalEncryptionContext(model.additionalEncryptionContext);
            associatedPortalArns(model.associatedPortalArns);
            browserPolicy(model.browserPolicy);
            browserSettingsArn(model.browserSettingsArn);
            customerManagedKey(model.customerManagedKey);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getBrowserPolicy() {
            return browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        @Override
        public BrowserSettings build() {
            return new BrowserSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
