/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data protection settings resource that can be associated with a web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProtectionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProtectionSettings.Builder, DataProtectionSettings> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(DataProtectionSettings::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(DataProtectionSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DataProtectionSettings::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(DataProtectionSettings::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProtectionSettingsArn").getter(getter(DataProtectionSettings::dataProtectionSettingsArn))
            .setter(setter(Builder::dataProtectionSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProtectionSettingsArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DataProtectionSettings::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(DataProtectionSettings::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<InlineRedactionConfiguration> INLINE_REDACTION_CONFIGURATION_FIELD = SdkField
            .<InlineRedactionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("inlineRedactionConfiguration")
            .getter(getter(DataProtectionSettings::inlineRedactionConfiguration))
            .setter(setter(Builder::inlineRedactionConfiguration))
            .constructor(InlineRedactionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, CREATION_DATE_FIELD, CUSTOMER_MANAGED_KEY_FIELD,
            DATA_PROTECTION_SETTINGS_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, INLINE_REDACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
                    put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
                    put("creationDate", CREATION_DATE_FIELD);
                    put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
                    put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("displayName", DISPLAY_NAME_FIELD);
                    put("inlineRedactionConfiguration", INLINE_REDACTION_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, String> additionalEncryptionContext;

    private final List<String> associatedPortalArns;

    private final Instant creationDate;

    private final String customerManagedKey;

    private final String dataProtectionSettingsArn;

    private final String description;

    private final String displayName;

    private final InlineRedactionConfiguration inlineRedactionConfiguration;

    private DataProtectionSettings(BuilderImpl builder) {
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.creationDate = builder.creationDate;
        this.customerManagedKey = builder.customerManagedKey;
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.inlineRedactionConfiguration = builder.inlineRedactionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the data protection settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the data protection settings.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this data protection settings resource is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this data protection settings resource is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * The creation date timestamp of the data protection settings.
     * </p>
     * 
     * @return The creation date timestamp of the data protection settings.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The customer managed key used to encrypt sensitive information in the data protection settings.
     * </p>
     * 
     * @return The customer managed key used to encrypt sensitive information in the data protection settings.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * <p>
     * The ARN of the data protection settings resource.
     * </p>
     * 
     * @return The ARN of the data protection settings resource.
     */
    public final String dataProtectionSettingsArn() {
        return dataProtectionSettingsArn;
    }

    /**
     * <p>
     * The description of the data protection settings.
     * </p>
     * 
     * @return The description of the data protection settings.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the data protection settings.
     * </p>
     * 
     * @return The display name of the data protection settings.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The inline redaction configuration for the data protection settings.
     * </p>
     * 
     * @return The inline redaction configuration for the data protection settings.
     */
    public final InlineRedactionConfiguration inlineRedactionConfiguration() {
        return inlineRedactionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(inlineRedactionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtectionSettings)) {
            return false;
        }
        DataProtectionSettings other = (DataProtectionSettings) obj;
        return hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(customerManagedKey(), other.customerManagedKey())
                && Objects.equals(dataProtectionSettingsArn(), other.dataProtectionSettingsArn())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(inlineRedactionConfiguration(), other.inlineRedactionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProtectionSettings")
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("CreationDate", creationDate()).add("CustomerManagedKey", customerManagedKey())
                .add("DataProtectionSettingsArn", dataProtectionSettingsArn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InlineRedactionConfiguration", inlineRedactionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "dataProtectionSettingsArn":
            return Optional.ofNullable(clazz.cast(dataProtectionSettingsArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "inlineRedactionConfiguration":
            return Optional.ofNullable(clazz.cast(inlineRedactionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataProtectionSettings, T> g) {
        return obj -> g.apply((DataProtectionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProtectionSettings> {
        /**
         * <p>
         * The additional encryption context of the data protection settings.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * A list of web portal ARNs that this data protection settings resource is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this data protection settings resource is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this data protection settings resource is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this data protection settings resource is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * The creation date timestamp of the data protection settings.
         * </p>
         * 
         * @param creationDate
         *        The creation date timestamp of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The customer managed key used to encrypt sensitive information in the data protection settings.
         * </p>
         * 
         * @param customerManagedKey
         *        The customer managed key used to encrypt sensitive information in the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The ARN of the data protection settings resource.
         * </p>
         * 
         * @param dataProtectionSettingsArn
         *        The ARN of the data protection settings resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionSettingsArn(String dataProtectionSettingsArn);

        /**
         * <p>
         * The description of the data protection settings.
         * </p>
         * 
         * @param description
         *        The description of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the data protection settings.
         * </p>
         * 
         * @param displayName
         *        The display name of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The inline redaction configuration for the data protection settings.
         * </p>
         * 
         * @param inlineRedactionConfiguration
         *        The inline redaction configuration for the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration);

        /**
         * <p>
         * The inline redaction configuration for the data protection settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineRedactionConfiguration.Builder}
         * avoiding the need to create one manually via {@link InlineRedactionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineRedactionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inlineRedactionConfiguration(InlineRedactionConfiguration)}.
         * 
         * @param inlineRedactionConfiguration
         *        a consumer that will call methods on {@link InlineRedactionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineRedactionConfiguration(InlineRedactionConfiguration)
         */
        default Builder inlineRedactionConfiguration(Consumer<InlineRedactionConfiguration.Builder> inlineRedactionConfiguration) {
            return inlineRedactionConfiguration(InlineRedactionConfiguration.builder()
                    .applyMutation(inlineRedactionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private String customerManagedKey;

        private String dataProtectionSettingsArn;

        private String description;

        private String displayName;

        private InlineRedactionConfiguration inlineRedactionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtectionSettings model) {
            additionalEncryptionContext(model.additionalEncryptionContext);
            associatedPortalArns(model.associatedPortalArns);
            creationDate(model.creationDate);
            customerManagedKey(model.customerManagedKey);
            dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            description(model.description);
            displayName(model.displayName);
            inlineRedactionConfiguration(model.inlineRedactionConfiguration);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final String getDataProtectionSettingsArn() {
            return dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final InlineRedactionConfiguration.Builder getInlineRedactionConfiguration() {
            return inlineRedactionConfiguration != null ? inlineRedactionConfiguration.toBuilder() : null;
        }

        public final void setInlineRedactionConfiguration(InlineRedactionConfiguration.BuilderImpl inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration != null ? inlineRedactionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration;
            return this;
        }

        @Override
        public DataProtectionSettings build() {
            return new DataProtectionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
