/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of network settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkSettingsSummary.Builder, NetworkSettingsSummary> {
    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(NetworkSettingsSummary::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(NetworkSettingsSummary::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_SETTINGS_ARN_FIELD,
            VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("networkSettingsArn", NETWORK_SETTINGS_ARN_FIELD);
                    put("vpcId", VPC_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String networkSettingsArn;

    private final String vpcId;

    private NetworkSettingsSummary(BuilderImpl builder) {
        this.networkSettingsArn = builder.networkSettingsArn;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ARN of the network settings.
     * </p>
     * 
     * @return The ARN of the network settings.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    /**
     * <p>
     * The VPC ID of the network settings.
     * </p>
     * 
     * @return The VPC ID of the network settings.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSettingsSummary)) {
            return false;
        }
        NetworkSettingsSummary other = (NetworkSettingsSummary) obj;
        return Objects.equals(networkSettingsArn(), other.networkSettingsArn()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkSettingsSummary").add("NetworkSettingsArn", networkSettingsArn()).add("VpcId", vpcId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkSettingsSummary, T> g) {
        return obj -> g.apply((NetworkSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkSettingsSummary> {
        /**
         * <p>
         * The ARN of the network settings.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        /**
         * <p>
         * The VPC ID of the network settings.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String networkSettingsArn;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSettingsSummary model) {
            networkSettingsArn(model.networkSettingsArn);
            vpcId(model.vpcId);
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkSettingsSummary build() {
            return new NetworkSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
