/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataProtectionSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateDataProtectionSettingsRequest.Builder, UpdateDataProtectionSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDataProtectionSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dataProtectionSettingsArn")
            .getter(getter(UpdateDataProtectionSettingsRequest::dataProtectionSettingsArn))
            .setter(setter(Builder::dataProtectionSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("dataProtectionSettingsArn")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDataProtectionSettingsRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateDataProtectionSettingsRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<InlineRedactionConfiguration> INLINE_REDACTION_CONFIGURATION_FIELD = SdkField
            .<InlineRedactionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("inlineRedactionConfiguration")
            .getter(getter(UpdateDataProtectionSettingsRequest::inlineRedactionConfiguration))
            .setter(setter(Builder::inlineRedactionConfiguration))
            .constructor(InlineRedactionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_PROTECTION_SETTINGS_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, INLINE_REDACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String dataProtectionSettingsArn;

    private final String description;

    private final String displayName;

    private final InlineRedactionConfiguration inlineRedactionConfiguration;

    private UpdateDataProtectionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.inlineRedactionConfiguration = builder.inlineRedactionConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN of the data protection settings.
     * </p>
     * 
     * @return The ARN of the data protection settings.
     */
    public final String dataProtectionSettingsArn() {
        return dataProtectionSettingsArn;
    }

    /**
     * <p>
     * The description of the data protection settings.
     * </p>
     * 
     * @return The description of the data protection settings.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the data protection settings.
     * </p>
     * 
     * @return The display name of the data protection settings.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The inline redaction configuration of the data protection settings that will be applied to all sessions.
     * </p>
     * 
     * @return The inline redaction configuration of the data protection settings that will be applied to all sessions.
     */
    public final InlineRedactionConfiguration inlineRedactionConfiguration() {
        return inlineRedactionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(inlineRedactionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataProtectionSettingsRequest)) {
            return false;
        }
        UpdateDataProtectionSettingsRequest other = (UpdateDataProtectionSettingsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dataProtectionSettingsArn(), other.dataProtectionSettingsArn())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(inlineRedactionConfiguration(), other.inlineRedactionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataProtectionSettingsRequest").add("ClientToken", clientToken())
                .add("DataProtectionSettingsArn", dataProtectionSettingsArn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InlineRedactionConfiguration", inlineRedactionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "dataProtectionSettingsArn":
            return Optional.ofNullable(clazz.cast(dataProtectionSettingsArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "inlineRedactionConfiguration":
            return Optional.ofNullable(clazz.cast(inlineRedactionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("inlineRedactionConfiguration", INLINE_REDACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataProtectionSettingsRequest, T> g) {
        return obj -> g.apply((UpdateDataProtectionSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDataProtectionSettingsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN of the data protection settings.
         * </p>
         * 
         * @param dataProtectionSettingsArn
         *        The ARN of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionSettingsArn(String dataProtectionSettingsArn);

        /**
         * <p>
         * The description of the data protection settings.
         * </p>
         * 
         * @param description
         *        The description of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the data protection settings.
         * </p>
         * 
         * @param displayName
         *        The display name of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The inline redaction configuration of the data protection settings that will be applied to all sessions.
         * </p>
         * 
         * @param inlineRedactionConfiguration
         *        The inline redaction configuration of the data protection settings that will be applied to all
         *        sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration);

        /**
         * <p>
         * The inline redaction configuration of the data protection settings that will be applied to all sessions.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineRedactionConfiguration.Builder}
         * avoiding the need to create one manually via {@link InlineRedactionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineRedactionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inlineRedactionConfiguration(InlineRedactionConfiguration)}.
         * 
         * @param inlineRedactionConfiguration
         *        a consumer that will call methods on {@link InlineRedactionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineRedactionConfiguration(InlineRedactionConfiguration)
         */
        default Builder inlineRedactionConfiguration(Consumer<InlineRedactionConfiguration.Builder> inlineRedactionConfiguration) {
            return inlineRedactionConfiguration(InlineRedactionConfiguration.builder()
                    .applyMutation(inlineRedactionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String dataProtectionSettingsArn;

        private String description;

        private String displayName;

        private InlineRedactionConfiguration inlineRedactionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataProtectionSettingsRequest model) {
            super(model);
            clientToken(model.clientToken);
            dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            description(model.description);
            displayName(model.displayName);
            inlineRedactionConfiguration(model.inlineRedactionConfiguration);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataProtectionSettingsArn() {
            return dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final InlineRedactionConfiguration.Builder getInlineRedactionConfiguration() {
            return inlineRedactionConfiguration != null ? inlineRedactionConfiguration.toBuilder() : null;
        }

        public final void setInlineRedactionConfiguration(InlineRedactionConfiguration.BuilderImpl inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration != null ? inlineRedactionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataProtectionSettingsRequest build() {
            return new UpdateDataProtectionSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
