/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrustStoresResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListTrustStoresResponse.Builder, ListTrustStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTrustStoresResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TrustStoreSummary>> TRUST_STORES_FIELD = SdkField
            .<List<TrustStoreSummary>> builder(MarshallingType.LIST)
            .memberName("trustStores")
            .getter(getter(ListTrustStoresResponse::trustStores))
            .setter(setter(Builder::trustStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustStoreSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustStoreSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRUST_STORES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<TrustStoreSummary> trustStores;

    private ListTrustStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trustStores = builder.trustStores;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrustStores() {
        return trustStores != null && !(trustStores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The trust stores.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustStores} method.
     * </p>
     * 
     * @return The trust stores.
     */
    public final List<TrustStoreSummary> trustStores() {
        return trustStores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustStores() ? trustStores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustStoresResponse)) {
            return false;
        }
        ListTrustStoresResponse other = (ListTrustStoresResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTrustStores() == other.hasTrustStores()
                && Objects.equals(trustStores(), other.trustStores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrustStoresResponse").add("NextToken", nextToken())
                .add("TrustStores", hasTrustStores() ? trustStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "trustStores":
            return Optional.ofNullable(clazz.cast(trustStores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trustStores", TRUST_STORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustStoresResponse, T> g) {
        return obj -> g.apply((ListTrustStoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrustStoresResponse> {
        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The trust stores.
         * </p>
         * 
         * @param trustStores
         *        The trust stores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStores(Collection<TrustStoreSummary> trustStores);

        /**
         * <p>
         * The trust stores.
         * </p>
         * 
         * @param trustStores
         *        The trust stores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStores(TrustStoreSummary... trustStores);

        /**
         * <p>
         * The trust stores.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #trustStores(List<TrustStoreSummary>)}.
         * 
         * @param trustStores
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStores(java.util.Collection<TrustStoreSummary>)
         */
        Builder trustStores(Consumer<TrustStoreSummary.Builder>... trustStores);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrustStoreSummary> trustStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustStoresResponse model) {
            super(model);
            nextToken(model.nextToken);
            trustStores(model.trustStores);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrustStoreSummary.Builder> getTrustStores() {
            List<TrustStoreSummary.Builder> result = TrustStoreSummaryListCopier.copyToBuilder(this.trustStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStores(Collection<TrustStoreSummary.BuilderImpl> trustStores) {
            this.trustStores = TrustStoreSummaryListCopier.copyFromBuilder(trustStores);
        }

        @Override
        public final Builder trustStores(Collection<TrustStoreSummary> trustStores) {
            this.trustStores = TrustStoreSummaryListCopier.copy(trustStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(TrustStoreSummary... trustStores) {
            trustStores(Arrays.asList(trustStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(Consumer<TrustStoreSummary.Builder>... trustStores) {
            trustStores(Stream.of(trustStores).map(c -> TrustStoreSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustStoresResponse build() {
            return new ListTrustStoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
