/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A user access logging settings resource that can be associated with a web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAccessLoggingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<UserAccessLoggingSettings.Builder, UserAccessLoggingSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(UserAccessLoggingSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kinesisStreamArn").getter(getter(UserAccessLoggingSettings::kinesisStreamArn))
            .setter(setter(Builder::kinesisStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesisStreamArn").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(UserAccessLoggingSettings::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD,
            KINESIS_STREAM_ARN_FIELD, USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> associatedPortalArns;

    private final String kinesisStreamArn;

    private final String userAccessLoggingSettingsArn;

    private UserAccessLoggingSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.kinesisStreamArn = builder.kinesisStreamArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this user access logging settings is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this user access logging settings is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * The ARN of the Kinesis stream.
     * </p>
     * 
     * @return The ARN of the Kinesis stream.
     */
    public final String kinesisStreamArn() {
        return kinesisStreamArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings.
     * </p>
     * 
     * @return The ARN of the user access logging settings.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessLoggingSettings)) {
            return false;
        }
        UserAccessLoggingSettings other = (UserAccessLoggingSettings) obj;
        return hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(kinesisStreamArn(), other.kinesisStreamArn())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAccessLoggingSettings")
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("KinesisStreamArn", kinesisStreamArn()).add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "kinesisStreamArn":
            return Optional.ofNullable(clazz.cast(kinesisStreamArn()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("kinesisStreamArn", KINESIS_STREAM_ARN_FIELD);
        map.put("userAccessLoggingSettingsArn", USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserAccessLoggingSettings, T> g) {
        return obj -> g.apply((UserAccessLoggingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAccessLoggingSettings> {
        /**
         * <p>
         * A list of web portal ARNs that this user access logging settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this user access logging settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this user access logging settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this user access logging settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * The ARN of the Kinesis stream.
         * </p>
         * 
         * @param kinesisStreamArn
         *        The ARN of the Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamArn(String kinesisStreamArn);

        /**
         * <p>
         * The ARN of the user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private String kinesisStreamArn;

        private String userAccessLoggingSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessLoggingSettings model) {
            associatedPortalArns(model.associatedPortalArns);
            kinesisStreamArn(model.kinesisStreamArn);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getKinesisStreamArn() {
            return kinesisStreamArn;
        }

        public final void setKinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
        }

        @Override
        public final Builder kinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        @Override
        public UserAccessLoggingSettings build() {
            return new UserAccessLoggingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
