/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workspacesweb.model.AccessDeniedException;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ConflictException;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ExpireSessionRequest;
import software.amazon.awssdk.services.workspacesweb.model.ExpireSessionResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetSessionRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetSessionResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.InternalServerException;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspacesweb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ThrottlingException;
import software.amazon.awssdk.services.workspacesweb.model.TooManyTagsException;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateDataProtectionSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateDataProtectionSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ValidationException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebException;
import software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable;

/**
 * Service client for accessing Amazon WorkSpaces Web. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon WorkSpaces Secure Browser is a low cost, fully managed WorkSpace built specifically to facilitate secure,
 * web-based workloads. WorkSpaces Secure Browser makes it easy for customers to safely provide their employees with
 * access to internal websites and SaaS web applications without the administrative burden of appliances or specialized
 * client software. WorkSpaces Secure Browser provides simple policy tools tailored for user interactions, while
 * offloading common tasks like capacity management, scaling, and maintaining browser images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkSpacesWebClient extends AwsClient {
    String SERVICE_NAME = "workspaces-web";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces-web";

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     *
     * @param associateBrowserSettingsRequest
     * @return Result of the AssociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBrowserSettingsResponse associateBrowserSettings(
            AssociateBrowserSettingsRequest associateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBrowserSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param associateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateBrowserSettingsResponse associateBrowserSettings(
            Consumer<AssociateBrowserSettingsRequest.Builder> associateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateBrowserSettings(AssociateBrowserSettingsRequest.builder().applyMutation(associateBrowserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Associates a data protection settings resource with a web portal.
     * </p>
     *
     * @param associateDataProtectionSettingsRequest
     * @return Result of the AssociateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDataProtectionSettingsResponse associateDataProtectionSettings(
            AssociateDataProtectionSettingsRequest associateDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a data protection settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDataProtectionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param associateDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateDataProtectionSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDataProtectionSettingsResponse associateDataProtectionSettings(
            Consumer<AssociateDataProtectionSettingsRequest.Builder> associateDataProtectionSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateDataProtectionSettings(AssociateDataProtectionSettingsRequest.builder()
                .applyMutation(associateDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Associates an IP access settings resource with a web portal.
     * </p>
     *
     * @param associateIpAccessSettingsRequest
     * @return Result of the AssociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIpAccessSettingsResponse associateIpAccessSettings(
            AssociateIpAccessSettingsRequest associateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an IP access settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpAccessSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param associateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIpAccessSettingsResponse associateIpAccessSettings(
            Consumer<AssociateIpAccessSettingsRequest.Builder> associateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateIpAccessSettings(AssociateIpAccessSettingsRequest.builder()
                .applyMutation(associateIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     *
     * @param associateNetworkSettingsRequest
     * @return Result of the AssociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateNetworkSettingsResponse associateNetworkSettings(
            AssociateNetworkSettingsRequest associateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateNetworkSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param associateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateNetworkSettingsResponse associateNetworkSettings(
            Consumer<AssociateNetworkSettingsRequest.Builder> associateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateNetworkSettings(AssociateNetworkSettingsRequest.builder().applyMutation(associateNetworkSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     *
     * @param associateTrustStoreRequest
     * @return Result of the AssociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrustStoreResponse associateTrustStore(AssociateTrustStoreRequest associateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrustStoreRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateTrustStoreRequest#builder()}
     * </p>
     *
     * @param associateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrustStoreResponse associateTrustStore(
            Consumer<AssociateTrustStoreRequest.Builder> associateTrustStoreRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateTrustStore(AssociateTrustStoreRequest.builder().applyMutation(associateTrustStoreRequest).build());
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     * @return Result of the AssociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserAccessLoggingSettingsResponse associateUserAccessLoggingSettings(
            AssociateUserAccessLoggingSettingsRequest associateUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserAccessLoggingSettingsResponse associateUserAccessLoggingSettings(
            Consumer<AssociateUserAccessLoggingSettingsRequest.Builder> associateUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateUserAccessLoggingSettings(AssociateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(associateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     *
     * @param associateUserSettingsRequest
     * @return Result of the AssociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserSettingsResponse associateUserSettings(AssociateUserSettingsRequest associateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateUserSettingsRequest#builder()}
     * </p>
     *
     * @param associateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserSettingsResponse associateUserSettings(
            Consumer<AssociateUserSettingsRequest.Builder> associateUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return associateUserSettings(AssociateUserSettingsRequest.builder().applyMutation(associateUserSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     *
     * @param createBrowserSettingsRequest
     * @return Result of the CreateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBrowserSettingsResponse createBrowserSettings(CreateBrowserSettingsRequest createBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param createBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the CreateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBrowserSettingsResponse createBrowserSettings(
            Consumer<CreateBrowserSettingsRequest.Builder> createBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createBrowserSettings(CreateBrowserSettingsRequest.builder().applyMutation(createBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a data protection settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createDataProtectionSettingsRequest
     * @return Result of the CreateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataProtectionSettingsResponse createDataProtectionSettings(
            CreateDataProtectionSettingsRequest createDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data protection settings resource that can be associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProtectionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param createDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataProtectionSettingsResponse createDataProtectionSettings(
            Consumer<CreateDataProtectionSettingsRequest.Builder> createDataProtectionSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return createDataProtectionSettings(CreateDataProtectionSettingsRequest.builder()
                .applyMutation(createDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param createIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest.Builder} to
     *        create a request.
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIdentityProviderResponse createIdentityProvider(
            Consumer<CreateIdentityProviderRequest.Builder> createIdentityProviderRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createIdentityProvider(CreateIdentityProviderRequest.builder().applyMutation(createIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates an IP access settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createIpAccessSettingsRequest
     * @return Result of the CreateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpAccessSettingsResponse createIpAccessSettings(CreateIpAccessSettingsRequest createIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IP access settings resource that can be associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param createIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the CreateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIpAccessSettingsResponse createIpAccessSettings(
            Consumer<CreateIpAccessSettingsRequest.Builder> createIpAccessSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createIpAccessSettings(CreateIpAccessSettingsRequest.builder().applyMutation(createIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     *
     * @param createNetworkSettingsRequest
     * @return Result of the CreateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkSettingsResponse createNetworkSettings(CreateNetworkSettingsRequest createNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param createNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the CreateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNetworkSettingsResponse createNetworkSettings(
            Consumer<CreateNetworkSettingsRequest.Builder> createNetworkSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createNetworkSettings(CreateNetworkSettingsRequest.builder().applyMutation(createNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     *
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePortalResponse createPortal(CreatePortalRequest createPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePortalRequest#builder()}
     * </p>
     *
     * @param createPortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CreatePortalResponse createPortal(Consumer<CreatePortalRequest.Builder> createPortalRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return createPortal(CreatePortalRequest.builder().applyMutation(createPortalRequest).build());
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return Result of the CreateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrustStoreResponse createTrustStore(CreateTrustStoreRequest createTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrustStoreRequest#builder()}
     * </p>
     *
     * @param createTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrustStoreResponse createTrustStore(Consumer<CreateTrustStoreRequest.Builder> createTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createTrustStore(CreateTrustStoreRequest.builder().applyMutation(createTrustStoreRequest).build());
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     * @return Result of the CreateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserAccessLoggingSettingsResponse createUserAccessLoggingSettings(
            CreateUserAccessLoggingSettingsRequest createUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the CreateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserAccessLoggingSettingsResponse createUserAccessLoggingSettings(
            Consumer<CreateUserAccessLoggingSettingsRequest.Builder> createUserAccessLoggingSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createUserAccessLoggingSettings(CreateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(createUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     *
     * @param createUserSettingsRequest
     * @return Result of the CreateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserSettingsResponse createUserSettings(CreateUserSettingsRequest createUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserSettingsRequest#builder()}
     * </p>
     *
     * @param createUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserSettingsResponse createUserSettings(Consumer<CreateUserSettingsRequest.Builder> createUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return createUserSettings(CreateUserSettingsRequest.builder().applyMutation(createUserSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     * @return Result of the DeleteBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBrowserSettingsResponse deleteBrowserSettings(DeleteBrowserSettingsRequest deleteBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBrowserSettingsResponse deleteBrowserSettings(
            Consumer<DeleteBrowserSettingsRequest.Builder> deleteBrowserSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return deleteBrowserSettings(DeleteBrowserSettingsRequest.builder().applyMutation(deleteBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes data protection settings.
     * </p>
     *
     * @param deleteDataProtectionSettingsRequest
     * @return Result of the DeleteDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataProtectionSettingsResponse deleteDataProtectionSettings(
            DeleteDataProtectionSettingsRequest deleteDataProtectionSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes data protection settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProtectionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param deleteDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataProtectionSettingsResponse deleteDataProtectionSettings(
            Consumer<DeleteDataProtectionSettingsRequest.Builder> deleteDataProtectionSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return deleteDataProtectionSettings(DeleteDataProtectionSettingsRequest.builder()
                .applyMutation(deleteDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deleteIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIdentityProviderResponse deleteIdentityProvider(
            Consumer<DeleteIdentityProviderRequest.Builder> deleteIdentityProviderRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return deleteIdentityProvider(DeleteIdentityProviderRequest.builder().applyMutation(deleteIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes IP access settings.
     * </p>
     *
     * @param deleteIpAccessSettingsRequest
     * @return Result of the DeleteIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpAccessSettingsResponse deleteIpAccessSettings(DeleteIpAccessSettingsRequest deleteIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param deleteIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIpAccessSettingsResponse deleteIpAccessSettings(
            Consumer<DeleteIpAccessSettingsRequest.Builder> deleteIpAccessSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return deleteIpAccessSettings(DeleteIpAccessSettingsRequest.builder().applyMutation(deleteIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     * @return Result of the DeleteNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkSettingsResponse deleteNetworkSettings(DeleteNetworkSettingsRequest deleteNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNetworkSettingsResponse deleteNetworkSettings(
            Consumer<DeleteNetworkSettingsRequest.Builder> deleteNetworkSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return deleteNetworkSettings(DeleteNetworkSettingsRequest.builder().applyMutation(deleteNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     *
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePortalResponse deletePortal(DeletePortalRequest deletePortalRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePortalRequest#builder()}
     * </p>
     *
     * @param deletePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default DeletePortalResponse deletePortal(Consumer<DeletePortalRequest.Builder> deletePortalRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return deletePortal(DeletePortalRequest.builder().applyMutation(deletePortalRequest).build());
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return Result of the DeleteTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrustStoreResponse deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTrustStoreRequest#builder()}
     * </p>
     *
     * @param deleteTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrustStoreResponse deleteTrustStore(Consumer<DeleteTrustStoreRequest.Builder> deleteTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return deleteTrustStore(DeleteTrustStoreRequest.builder().applyMutation(deleteTrustStoreRequest).build());
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     * @return Result of the DeleteUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserAccessLoggingSettingsResponse deleteUserAccessLoggingSettings(
            DeleteUserAccessLoggingSettingsRequest deleteUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserAccessLoggingSettingsResponse deleteUserAccessLoggingSettings(
            Consumer<DeleteUserAccessLoggingSettingsRequest.Builder> deleteUserAccessLoggingSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return deleteUserAccessLoggingSettings(DeleteUserAccessLoggingSettingsRequest.builder()
                .applyMutation(deleteUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     *
     * @param deleteUserSettingsRequest
     * @return Result of the DeleteUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserSettingsResponse deleteUserSettings(DeleteUserSettingsRequest deleteUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserSettingsRequest#builder()}
     * </p>
     *
     * @param deleteUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserSettingsResponse deleteUserSettings(Consumer<DeleteUserSettingsRequest.Builder> deleteUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return deleteUserSettings(DeleteUserSettingsRequest.builder().applyMutation(deleteUserSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     * @return Result of the DisassociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBrowserSettingsResponse disassociateBrowserSettings(
            DisassociateBrowserSettingsRequest disassociateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBrowserSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateBrowserSettingsResponse disassociateBrowserSettings(
            Consumer<DisassociateBrowserSettingsRequest.Builder> disassociateBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateBrowserSettings(DisassociateBrowserSettingsRequest.builder()
                .applyMutation(disassociateBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates data protection settings from a web portal.
     * </p>
     *
     * @param disassociateDataProtectionSettingsRequest
     * @return Result of the DisassociateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateDataProtectionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDataProtectionSettingsResponse disassociateDataProtectionSettings(
            DisassociateDataProtectionSettingsRequest disassociateDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates data protection settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDataProtectionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateDataProtectionSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateDataProtectionSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDataProtectionSettingsResponse disassociateDataProtectionSettings(
            Consumer<DisassociateDataProtectionSettingsRequest.Builder> disassociateDataProtectionSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateDataProtectionSettings(DisassociateDataProtectionSettingsRequest.builder()
                .applyMutation(disassociateDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates IP access settings from a web portal.
     * </p>
     *
     * @param disassociateIpAccessSettingsRequest
     * @return Result of the DisassociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpAccessSettingsResponse disassociateIpAccessSettings(
            DisassociateIpAccessSettingsRequest disassociateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates IP access settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIpAccessSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIpAccessSettingsResponse disassociateIpAccessSettings(
            Consumer<DisassociateIpAccessSettingsRequest.Builder> disassociateIpAccessSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateIpAccessSettings(DisassociateIpAccessSettingsRequest.builder()
                .applyMutation(disassociateIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     * @return Result of the DisassociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateNetworkSettingsResponse disassociateNetworkSettings(
            DisassociateNetworkSettingsRequest disassociateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateNetworkSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateNetworkSettingsResponse disassociateNetworkSettings(
            Consumer<DisassociateNetworkSettingsRequest.Builder> disassociateNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateNetworkSettings(DisassociateNetworkSettingsRequest.builder()
                .applyMutation(disassociateNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     *
     * @param disassociateTrustStoreRequest
     * @return Result of the DisassociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrustStoreResponse disassociateTrustStore(DisassociateTrustStoreRequest disassociateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTrustStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateTrustStoreRequest#builder()}
     * </p>
     *
     * @param disassociateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrustStoreResponse disassociateTrustStore(
            Consumer<DisassociateTrustStoreRequest.Builder> disassociateTrustStoreRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateTrustStore(DisassociateTrustStoreRequest.builder().applyMutation(disassociateTrustStoreRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     * @return Result of the DisassociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserAccessLoggingSettingsResponse disassociateUserAccessLoggingSettings(
            DisassociateUserAccessLoggingSettingsRequest disassociateUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateUserAccessLoggingSettingsRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserAccessLoggingSettingsResponse disassociateUserAccessLoggingSettings(
            Consumer<DisassociateUserAccessLoggingSettingsRequest.Builder> disassociateUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateUserAccessLoggingSettings(DisassociateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(disassociateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     *
     * @param disassociateUserSettingsRequest
     * @return Result of the DisassociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserSettingsResponse disassociateUserSettings(
            DisassociateUserSettingsRequest disassociateUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateUserSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserSettingsResponse disassociateUserSettings(
            Consumer<DisassociateUserSettingsRequest.Builder> disassociateUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        return disassociateUserSettings(DisassociateUserSettingsRequest.builder().applyMutation(disassociateUserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Expires an active secure browser session.
     * </p>
     *
     * @param expireSessionRequest
     * @return Result of the ExpireSession operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ExpireSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ExpireSession" target="_top">AWS
     *      API Documentation</a>
     */
    default ExpireSessionResponse expireSession(ExpireSessionRequest expireSessionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Expires an active secure browser session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExpireSessionRequest.Builder} avoiding the need to
     * create one manually via {@link ExpireSessionRequest#builder()}
     * </p>
     *
     * @param expireSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ExpireSessionRequest.Builder} to create a
     *        request.
     * @return Result of the ExpireSession operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ExpireSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ExpireSession" target="_top">AWS
     *      API Documentation</a>
     */
    default ExpireSessionResponse expireSession(Consumer<ExpireSessionRequest.Builder> expireSessionRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return expireSession(ExpireSessionRequest.builder().applyMutation(expireSessionRequest).build());
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     *
     * @param getBrowserSettingsRequest
     * @return Result of the GetBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserSettingsResponse getBrowserSettings(GetBrowserSettingsRequest getBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param getBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBrowserSettingsResponse getBrowserSettings(Consumer<GetBrowserSettingsRequest.Builder> getBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getBrowserSettings(GetBrowserSettingsRequest.builder().applyMutation(getBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the data protection settings.
     * </p>
     *
     * @param getDataProtectionSettingsRequest
     * @return Result of the GetDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataProtectionSettingsResponse getDataProtectionSettings(
            GetDataProtectionSettingsRequest getDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the data protection settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataProtectionSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param getDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the GetDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataProtectionSettingsResponse getDataProtectionSettings(
            Consumer<GetDataProtectionSettingsRequest.Builder> getDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getDataProtectionSettings(GetDataProtectionSettingsRequest.builder()
                .applyMutation(getDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     *
     * @param getIdentityProviderRequest
     * @return Result of the GetIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityProviderResponse getIdentityProvider(GetIdentityProviderRequest getIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdentityProviderRequest#builder()}
     * </p>
     *
     * @param getIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the GetIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityProviderResponse getIdentityProvider(
            Consumer<GetIdentityProviderRequest.Builder> getIdentityProviderRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getIdentityProvider(GetIdentityProviderRequest.builder().applyMutation(getIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Gets the IP access settings.
     * </p>
     *
     * @param getIpAccessSettingsRequest
     * @return Result of the GetIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIpAccessSettingsResponse getIpAccessSettings(GetIpAccessSettingsRequest getIpAccessSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param getIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIpAccessSettingsResponse getIpAccessSettings(
            Consumer<GetIpAccessSettingsRequest.Builder> getIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getIpAccessSettings(GetIpAccessSettingsRequest.builder().applyMutation(getIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     *
     * @param getNetworkSettingsRequest
     * @return Result of the GetNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkSettingsResponse getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param getNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNetworkSettingsResponse getNetworkSettings(Consumer<GetNetworkSettingsRequest.Builder> getNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getNetworkSettings(GetNetworkSettingsRequest.builder().applyMutation(getNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     *
     * @param getPortalRequest
     * @return Result of the GetPortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPortalResponse getPortal(GetPortalRequest getPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortalRequest.Builder} avoiding the need to
     * create one manually via {@link GetPortalRequest#builder()}
     * </p>
     *
     * @param getPortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest.Builder} to create a request.
     * @return Result of the GetPortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPortalResponse getPortal(Consumer<GetPortalRequest.Builder> getPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getPortal(GetPortalRequest.builder().applyMutation(getPortalRequest).build());
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     * @return Result of the GetPortalServiceProviderMetadata operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortalServiceProviderMetadataResponse getPortalServiceProviderMetadata(
            GetPortalServiceProviderMetadataRequest getPortalServiceProviderMetadataRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortalServiceProviderMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetPortalServiceProviderMetadataRequest#builder()}
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest.Builder}
     *        to create a request.
     * @return Result of the GetPortalServiceProviderMetadata operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPortalServiceProviderMetadataResponse getPortalServiceProviderMetadata(
            Consumer<GetPortalServiceProviderMetadataRequest.Builder> getPortalServiceProviderMetadataRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest.builder()
                .applyMutation(getPortalServiceProviderMetadataRequest).build());
    }

    /**
     * <p>
     * Gets information for a secure browser session.
     * </p>
     *
     * @param getSessionRequest
     * @return Result of the GetSession operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information for a secure browser session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetSessionRequest.Builder} to create a request.
     * @return Result of the GetSession operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     *
     * @param getTrustStoreRequest
     * @return Result of the GetTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrustStoreResponse getTrustStore(GetTrustStoreRequest getTrustStoreRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrustStoreRequest#builder()}
     * </p>
     *
     * @param getTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTrustStoreResponse getTrustStore(Consumer<GetTrustStoreRequest.Builder> getTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getTrustStore(GetTrustStoreRequest.builder().applyMutation(getTrustStoreRequest).build());
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     * @return Result of the GetTrustStoreCertificate operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrustStoreCertificateResponse getTrustStoreCertificate(
            GetTrustStoreCertificateRequest getTrustStoreCertificateRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link GetTrustStoreCertificateRequest#builder()}
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest.Builder} to
     *        create a request.
     * @return Result of the GetTrustStoreCertificate operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrustStoreCertificateResponse getTrustStoreCertificate(
            Consumer<GetTrustStoreCertificateRequest.Builder> getTrustStoreCertificateRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return getTrustStoreCertificate(GetTrustStoreCertificateRequest.builder().applyMutation(getTrustStoreCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     * @return Result of the GetUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserAccessLoggingSettingsResponse getUserAccessLoggingSettings(
            GetUserAccessLoggingSettingsRequest getUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the GetUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserAccessLoggingSettingsResponse getUserAccessLoggingSettings(
            Consumer<GetUserAccessLoggingSettingsRequest.Builder> getUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getUserAccessLoggingSettings(GetUserAccessLoggingSettingsRequest.builder()
                .applyMutation(getUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return Result of the GetUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserSettingsResponse getUserSettings(GetUserSettingsRequest getUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link GetUserSettingsRequest#builder()}
     * </p>
     *
     * @param getUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetUserSettingsResponse getUserSettings(Consumer<GetUserSettingsRequest.Builder> getUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return getUserSettings(GetUserSettingsRequest.builder().applyMutation(getUserSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return Result of the ListBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsResponse listBrowserSettings(ListBrowserSettingsRequest listBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param listBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsResponse listBrowserSettings(
            Consumer<ListBrowserSettingsRequest.Builder> listBrowserSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listBrowserSettings(ListBrowserSettingsRequest.builder().applyMutation(listBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client
     *             .listBrowserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsIterable listBrowserSettingsPaginator(ListBrowserSettingsRequest listBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListBrowserSettingsIterable(this, listBrowserSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client
     *             .listBrowserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param listBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsIterable listBrowserSettingsPaginator(
            Consumer<ListBrowserSettingsRequest.Builder> listBrowserSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listBrowserSettingsPaginator(ListBrowserSettingsRequest.builder().applyMutation(listBrowserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of data protection settings.
     * </p>
     *
     * @param listDataProtectionSettingsRequest
     * @return Result of the ListDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProtectionSettingsResponse listDataProtectionSettings(
            ListDataProtectionSettingsRequest listDataProtectionSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of data protection settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProtectionSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param listDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProtectionSettingsResponse listDataProtectionSettings(
            Consumer<ListDataProtectionSettingsRequest.Builder> listDataProtectionSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listDataProtectionSettings(ListDataProtectionSettingsRequest.builder()
                .applyMutation(listDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProtectionSettings(software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client.listDataProtectionSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client
     *             .listDataProtectionSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client.listDataProtectionSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProtectionSettings(software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataProtectionSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProtectionSettingsIterable listDataProtectionSettingsPaginator(
            ListDataProtectionSettingsRequest listDataProtectionSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return new ListDataProtectionSettingsIterable(this, listDataProtectionSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataProtectionSettings(software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client.listDataProtectionSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client
     *             .listDataProtectionSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListDataProtectionSettingsIterable responses = client.listDataProtectionSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataProtectionSettings(software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataProtectionSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param listDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataProtectionSettingsIterable listDataProtectionSettingsPaginator(
            Consumer<ListDataProtectionSettingsRequest.Builder> listDataProtectionSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listDataProtectionSettingsPaginator(ListDataProtectionSettingsRequest.builder()
                .applyMutation(listDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest.Builder} to create
     *        a request.
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersResponse listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListIdentityProvidersIterable(this, listIdentityProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersIterable listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of IP access settings.
     * </p>
     *
     * @param listIpAccessSettingsRequest
     * @return Result of the ListIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsResponse listIpAccessSettings(ListIpAccessSettingsRequest listIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param listIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the ListIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsResponse listIpAccessSettings(
            Consumer<ListIpAccessSettingsRequest.Builder> listIpAccessSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listIpAccessSettings(ListIpAccessSettingsRequest.builder().applyMutation(listIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client.listIpAccessSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client
     *             .listIpAccessSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client.listIpAccessSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIpAccessSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsIterable listIpAccessSettingsPaginator(ListIpAccessSettingsRequest listIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListIpAccessSettingsIterable(this, listIpAccessSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client.listIpAccessSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client
     *             .listIpAccessSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsIterable responses = client.listIpAccessSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param listIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsIterable listIpAccessSettingsPaginator(
            Consumer<ListIpAccessSettingsRequest.Builder> listIpAccessSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listIpAccessSettingsPaginator(ListIpAccessSettingsRequest.builder().applyMutation(listIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return Result of the ListNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsResponse listNetworkSettings(ListNetworkSettingsRequest listNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param listNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsResponse listNetworkSettings(
            Consumer<ListNetworkSettingsRequest.Builder> listNetworkSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listNetworkSettings(ListNetworkSettingsRequest.builder().applyMutation(listNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client
     *             .listNetworkSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsIterable listNetworkSettingsPaginator(ListNetworkSettingsRequest listNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListNetworkSettingsIterable(this, listNetworkSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client
     *             .listNetworkSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param listNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsIterable listNetworkSettingsPaginator(
            Consumer<ListNetworkSettingsRequest.Builder> listNetworkSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return listNetworkSettingsPaginator(ListNetworkSettingsRequest.builder().applyMutation(listNetworkSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsResponse listPortals(ListPortalsRequest listPortalsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPortals operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsResponse listPortals(Consumer<ListPortalsRequest.Builder> listPortalsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listPortals(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsIterable listPortalsPaginator(ListPortalsRequest listPortalsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return new ListPortalsIterable(this, listPortalsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsIterable listPortalsPaginator(Consumer<ListPortalsRequest.Builder> listPortalsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listPortalsPaginator(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * Lists information for multiple secure browser sessions from a specific portal.
     * </p>
     *
     * @param listSessionsRequest
     * @return Result of the ListSessions operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionsResponse listSessions(ListSessionsRequest listSessionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information for multiple secure browser sessions from a specific portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSessions operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionsResponse listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest)} operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(ListSessionsRequest listSessionsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListSessionsIterable(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client
     *             .listSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListSessionsIterable responses = client.listSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSessionsIterable listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return Result of the ListTrustStoreCertificates operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesResponse listTrustStoreCertificates(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoreCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustStoreCertificatesRequest#builder()}
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest.Builder} to
     *        create a request.
     * @return Result of the ListTrustStoreCertificates operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesResponse listTrustStoreCertificates(
            Consumer<ListTrustStoreCertificatesRequest.Builder> listTrustStoreCertificatesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return listTrustStoreCertificates(ListTrustStoreCertificatesRequest.builder()
                .applyMutation(listTrustStoreCertificatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client
     *             .listTrustStoreCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesIterable listTrustStoreCertificatesPaginator(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListTrustStoreCertificatesIterable(this, listTrustStoreCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client
     *             .listTrustStoreCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoreCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustStoreCertificatesRequest#builder()}
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesIterable listTrustStoreCertificatesPaginator(
            Consumer<ListTrustStoreCertificatesRequest.Builder> listTrustStoreCertificatesRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return listTrustStoreCertificatesPaginator(ListTrustStoreCertificatesRequest.builder()
                .applyMutation(listTrustStoreCertificatesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     *
     * @param listTrustStoresRequest
     * @return Result of the ListTrustStores operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresResponse listTrustStores(ListTrustStoresRequest listTrustStoresRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustStoresRequest#builder()}
     * </p>
     *
     * @param listTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest.Builder} to create a
     *        request.
     * @return Result of the ListTrustStores operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresResponse listTrustStores(Consumer<ListTrustStoresRequest.Builder> listTrustStoresRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listTrustStores(ListTrustStoresRequest.builder().applyMutation(listTrustStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client
     *             .listTrustStoresPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresIterable listTrustStoresPaginator(ListTrustStoresRequest listTrustStoresRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListTrustStoresIterable(this, listTrustStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client
     *             .listTrustStoresPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustStoresRequest#builder()}
     * </p>
     *
     * @param listTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresIterable listTrustStoresPaginator(Consumer<ListTrustStoresRequest.Builder> listTrustStoresRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listTrustStoresPaginator(ListTrustStoresRequest.builder().applyMutation(listTrustStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return Result of the ListUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsResponse listUserAccessLoggingSettings(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the ListUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsResponse listUserAccessLoggingSettings(
            Consumer<ListUserAccessLoggingSettingsRequest.Builder> listUserAccessLoggingSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listUserAccessLoggingSettings(ListUserAccessLoggingSettingsRequest.builder()
                .applyMutation(listUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client.listUserAccessLoggingSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client
     *             .listUserAccessLoggingSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client.listUserAccessLoggingSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsIterable listUserAccessLoggingSettingsPaginator(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return new ListUserAccessLoggingSettingsIterable(this, listUserAccessLoggingSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client.listUserAccessLoggingSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client
     *             .listUserAccessLoggingSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsIterable responses = client.listUserAccessLoggingSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsIterable listUserAccessLoggingSettingsPaginator(
            Consumer<ListUserAccessLoggingSettingsRequest.Builder> listUserAccessLoggingSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listUserAccessLoggingSettingsPaginator(ListUserAccessLoggingSettingsRequest.builder()
                .applyMutation(listUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     *
     * @param listUserSettingsRequest
     * @return Result of the ListUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsResponse listUserSettings(ListUserSettingsRequest listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserSettingsRequest#builder()}
     * </p>
     *
     * @param listUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsResponse listUserSettings(Consumer<ListUserSettingsRequest.Builder> listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listUserSettings(ListUserSettingsRequest.builder().applyMutation(listUserSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client
     *             .listUserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsIterable listUserSettingsPaginator(ListUserSettingsRequest listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListUserSettingsIterable(this, listUserSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client
     *             .listUserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserSettingsRequest#builder()}
     * </p>
     *
     * @param listUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsIterable listUserSettingsPaginator(Consumer<ListUserSettingsRequest.Builder> listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return listUserSettingsPaginator(ListUserSettingsRequest.builder().applyMutation(listUserSettingsRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws TooManyTagsException
     *         There are too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, TooManyTagsException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws TooManyTagsException
     *         There are too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, TooManyTagsException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     *
     * @param updateBrowserSettingsRequest
     * @return Result of the UpdateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBrowserSettingsResponse updateBrowserSettings(UpdateBrowserSettingsRequest updateBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param updateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBrowserSettingsResponse updateBrowserSettings(
            Consumer<UpdateBrowserSettingsRequest.Builder> updateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return updateBrowserSettings(UpdateBrowserSettingsRequest.builder().applyMutation(updateBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Updates data protection settings.
     * </p>
     *
     * @param updateDataProtectionSettingsRequest
     * @return Result of the UpdateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataProtectionSettingsResponse updateDataProtectionSettings(
            UpdateDataProtectionSettingsRequest updateDataProtectionSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates data protection settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataProtectionSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDataProtectionSettingsRequest#builder()}
     * </p>
     *
     * @param updateDataProtectionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateDataProtectionSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDataProtectionSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateDataProtectionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateDataProtectionSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataProtectionSettingsResponse updateDataProtectionSettings(
            Consumer<UpdateDataProtectionSettingsRequest.Builder> updateDataProtectionSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return updateDataProtectionSettings(UpdateDataProtectionSettingsRequest.builder()
                .applyMutation(updateDataProtectionSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest updateIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIdentityProviderResponse updateIdentityProvider(
            Consumer<UpdateIdentityProviderRequest.Builder> updateIdentityProviderRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return updateIdentityProvider(UpdateIdentityProviderRequest.builder().applyMutation(updateIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates IP access settings.
     * </p>
     *
     * @param updateIpAccessSettingsRequest
     * @return Result of the UpdateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIpAccessSettingsResponse updateIpAccessSettings(UpdateIpAccessSettingsRequest updateIpAccessSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param updateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIpAccessSettingsResponse updateIpAccessSettings(
            Consumer<UpdateIpAccessSettingsRequest.Builder> updateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return updateIpAccessSettings(UpdateIpAccessSettingsRequest.builder().applyMutation(updateIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     *
     * @param updateNetworkSettingsRequest
     * @return Result of the UpdateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSettingsResponse updateNetworkSettings(UpdateNetworkSettingsRequest updateNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param updateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNetworkSettingsResponse updateNetworkSettings(
            Consumer<UpdateNetworkSettingsRequest.Builder> updateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return updateNetworkSettings(UpdateNetworkSettingsRequest.builder().applyMutation(updateNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePortalResponse updatePortal(UpdatePortalRequest updatePortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePortalRequest#builder()}
     * </p>
     *
     * @param updatePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdatePortalResponse updatePortal(Consumer<UpdatePortalRequest.Builder> updatePortalRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return updatePortal(UpdatePortalRequest.builder().applyMutation(updatePortalRequest).build());
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     *
     * @param updateTrustStoreRequest
     * @return Result of the UpdateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrustStoreResponse updateTrustStore(UpdateTrustStoreRequest updateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTrustStoreRequest#builder()}
     * </p>
     *
     * @param updateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTrustStoreResponse updateTrustStore(Consumer<UpdateTrustStoreRequest.Builder> updateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return updateTrustStore(UpdateTrustStoreRequest.builder().applyMutation(updateTrustStoreRequest).build());
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     * @return Result of the UpdateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserAccessLoggingSettingsResponse updateUserAccessLoggingSettings(
            UpdateUserAccessLoggingSettingsRequest updateUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserAccessLoggingSettingsResponse updateUserAccessLoggingSettings(
            Consumer<UpdateUserAccessLoggingSettingsRequest.Builder> updateUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return updateUserAccessLoggingSettings(UpdateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(updateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return Result of the UpdateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserSettingsResponse updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserSettingsRequest#builder()}
     * </p>
     *
     * @param updateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateUserSettingsResponse updateUserSettings(Consumer<UpdateUserSettingsRequest.Builder> updateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        return updateUserSettings(UpdateUserSettingsRequest.builder().applyMutation(updateUserSettingsRequest).build());
    }

    /**
     * Create a {@link WorkSpacesWebClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkSpacesWebClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkSpacesWebClient}.
     */
    static WorkSpacesWebClientBuilder builder() {
        return new DefaultWorkSpacesWebClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default WorkSpacesWebServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
