/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a secure browser session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<List<String>> CLIENT_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("clientIpAddresses")
            .getter(getter(Session::clientIpAddresses))
            .setter(setter(Builder::clientIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(Session::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(Session::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(Session::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(Session::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Session::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("username").getter(getter(Session::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IP_ADDRESSES_FIELD,
            END_TIME_FIELD, PORTAL_ARN_FIELD, SESSION_ID_FIELD, START_TIME_FIELD, STATUS_FIELD, USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> clientIpAddresses;

    private final Instant endTime;

    private final String portalArn;

    private final String sessionId;

    private final Instant startTime;

    private final String status;

    private final String username;

    private Session(BuilderImpl builder) {
        this.clientIpAddresses = builder.clientIpAddresses;
        this.endTime = builder.endTime;
        this.portalArn = builder.portalArn;
        this.sessionId = builder.sessionId;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.username = builder.username;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientIpAddresses() {
        return clientIpAddresses != null && !(clientIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address of the client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientIpAddresses} method.
     * </p>
     * 
     * @return The IP address of the client.
     */
    public final List<String> clientIpAddresses() {
        return clientIpAddresses;
    }

    /**
     * <p>
     * The end time of the session.
     * </p>
     * 
     * @return The end time of the session.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The start time of the session.
     * </p>
     * 
     * @return The start time of the session.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session.
     * @see SessionStatus
     */
    public final SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session.
     * @see SessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The username of the session.
     * </p>
     * 
     * @return The username of the session.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClientIpAddresses() ? clientIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return hasClientIpAddresses() == other.hasClientIpAddresses()
                && Objects.equals(clientIpAddresses(), other.clientIpAddresses()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(portalArn(), other.portalArn()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Session")
                .add("ClientIpAddresses", clientIpAddresses() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EndTime", endTime()).add("PortalArn", portalArn()).add("SessionId", sessionId())
                .add("StartTime", startTime()).add("Status", statusAsString())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientIpAddresses":
            return Optional.ofNullable(clazz.cast(clientIpAddresses()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientIpAddresses", CLIENT_IP_ADDRESSES_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("portalArn", PORTAL_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("username", USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The IP address of the client.
         * </p>
         * 
         * @param clientIpAddresses
         *        The IP address of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIpAddresses(Collection<String> clientIpAddresses);

        /**
         * <p>
         * The IP address of the client.
         * </p>
         * 
         * @param clientIpAddresses
         *        The IP address of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIpAddresses(String... clientIpAddresses);

        /**
         * <p>
         * The end time of the session.
         * </p>
         * 
         * @param endTime
         *        The end time of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The start time of the session.
         * </p>
         * 
         * @param startTime
         *        The start time of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of the session.
         * </p>
         * 
         * @param status
         *        The status of the session.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the session.
         * </p>
         * 
         * @param status
         *        The status of the session.
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * The username of the session.
         * </p>
         * 
         * @param username
         *        The username of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private List<String> clientIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Instant endTime;

        private String portalArn;

        private String sessionId;

        private Instant startTime;

        private String status;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            clientIpAddresses(model.clientIpAddresses);
            endTime(model.endTime);
            portalArn(model.portalArn);
            sessionId(model.sessionId);
            startTime(model.startTime);
            status(model.status);
            username(model.username);
        }

        public final Collection<String> getClientIpAddresses() {
            if (clientIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return clientIpAddresses;
        }

        public final void setClientIpAddresses(Collection<String> clientIpAddresses) {
            this.clientIpAddresses = IpAddressListCopier.copy(clientIpAddresses);
        }

        @Override
        public final Builder clientIpAddresses(Collection<String> clientIpAddresses) {
            this.clientIpAddresses = IpAddressListCopier.copy(clientIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIpAddresses(String... clientIpAddresses) {
            clientIpAddresses(Arrays.asList(clientIpAddresses));
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
