/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrustStoreCertificatesResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListTrustStoreCertificatesResponse.Builder, ListTrustStoreCertificatesResponse> {
    private static final SdkField<List<CertificateSummary>> CERTIFICATE_LIST_FIELD = SdkField
            .<List<CertificateSummary>> builder(MarshallingType.LIST)
            .memberName("certificateList")
            .getter(getter(ListTrustStoreCertificatesResponse::certificateList))
            .setter(setter(Builder::certificateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTrustStoreCertificatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustStoreArn").getter(getter(ListTrustStoreCertificatesResponse::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_LIST_FIELD,
            NEXT_TOKEN_FIELD, TRUST_STORE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CertificateSummary> certificateList;

    private final String nextToken;

    private final String trustStoreArn;

    private ListTrustStoreCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificateList = builder.certificateList;
        this.nextToken = builder.nextToken;
        this.trustStoreArn = builder.trustStoreArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificateList() {
        return certificateList != null && !(certificateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The certificate list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateList} method.
     * </p>
     * 
     * @return The certificate list.
     */
    public final List<CertificateSummary> certificateList() {
        return certificateList;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.&gt;
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.&gt;
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     * 
     * @return The ARN of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateList() ? certificateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustStoreCertificatesResponse)) {
            return false;
        }
        ListTrustStoreCertificatesResponse other = (ListTrustStoreCertificatesResponse) obj;
        return hasCertificateList() == other.hasCertificateList() && Objects.equals(certificateList(), other.certificateList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(trustStoreArn(), other.trustStoreArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrustStoreCertificatesResponse")
                .add("CertificateList", hasCertificateList() ? certificateList() : null).add("NextToken", nextToken())
                .add("TrustStoreArn", trustStoreArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateList":
            return Optional.ofNullable(clazz.cast(certificateList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "trustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateList", CERTIFICATE_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustStoreCertificatesResponse, T> g) {
        return obj -> g.apply((ListTrustStoreCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrustStoreCertificatesResponse> {
        /**
         * <p>
         * The certificate list.
         * </p>
         * 
         * @param certificateList
         *        The certificate list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateList(Collection<CertificateSummary> certificateList);

        /**
         * <p>
         * The certificate list.
         * </p>
         * 
         * @param certificateList
         *        The certificate list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateList(CertificateSummary... certificateList);

        /**
         * <p>
         * The certificate list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.CertificateSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.CertificateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.CertificateSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #certificateList(List<CertificateSummary>)}.
         * 
         * @param certificateList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.CertificateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateList(java.util.Collection<CertificateSummary>)
         */
        Builder certificateList(Consumer<CertificateSummary.Builder>... certificateList);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.&gt;
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ARN of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The ARN of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<CertificateSummary> certificateList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String trustStoreArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustStoreCertificatesResponse model) {
            super(model);
            certificateList(model.certificateList);
            nextToken(model.nextToken);
            trustStoreArn(model.trustStoreArn);
        }

        public final List<CertificateSummary.Builder> getCertificateList() {
            List<CertificateSummary.Builder> result = CertificateSummaryListCopier.copyToBuilder(this.certificateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateList(Collection<CertificateSummary.BuilderImpl> certificateList) {
            this.certificateList = CertificateSummaryListCopier.copyFromBuilder(certificateList);
        }

        @Override
        public final Builder certificateList(Collection<CertificateSummary> certificateList) {
            this.certificateList = CertificateSummaryListCopier.copy(certificateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateList(CertificateSummary... certificateList) {
            certificateList(Arrays.asList(certificateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateList(Consumer<CertificateSummary.Builder>... certificateList) {
            certificateList(Stream.of(certificateList).map(c -> CertificateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        @Override
        public ListTrustStoreCertificatesResponse build() {
            return new ListTrustStoreCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
