/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote
 * browser.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CookieSynchronizationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CookieSynchronizationConfiguration.Builder, CookieSynchronizationConfiguration> {
    private static final SdkField<List<CookieSpecification>> ALLOWLIST_FIELD = SdkField
            .<List<CookieSpecification>> builder(MarshallingType.LIST)
            .memberName("allowlist")
            .getter(getter(CookieSynchronizationConfiguration::allowlist))
            .setter(setter(Builder::allowlist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowlist").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CookieSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(CookieSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CookieSpecification>> BLOCKLIST_FIELD = SdkField
            .<List<CookieSpecification>> builder(MarshallingType.LIST)
            .memberName("blocklist")
            .getter(getter(CookieSynchronizationConfiguration::blocklist))
            .setter(setter(Builder::blocklist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocklist").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CookieSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(CookieSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWLIST_FIELD,
            BLOCKLIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CookieSpecification> allowlist;

    private final List<CookieSpecification> blocklist;

    private CookieSynchronizationConfiguration(BuilderImpl builder) {
        this.allowlist = builder.allowlist;
        this.blocklist = builder.blocklist;
    }

    /**
     * For responses, this returns true if the service returned a value for the Allowlist property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllowlist() {
        return allowlist != null && !(allowlist instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of cookie specifications that are allowed to be synchronized to the remote browser.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowlist} method.
     * </p>
     * 
     * @return The list of cookie specifications that are allowed to be synchronized to the remote browser.
     */
    public final List<CookieSpecification> allowlist() {
        return allowlist;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blocklist property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlocklist() {
        return blocklist != null && !(blocklist instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of cookie specifications that are blocked from being synchronized to the remote browser.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlocklist} method.
     * </p>
     * 
     * @return The list of cookie specifications that are blocked from being synchronized to the remote browser.
     */
    public final List<CookieSpecification> blocklist() {
        return blocklist;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowlist() ? allowlist() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlocklist() ? blocklist() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieSynchronizationConfiguration)) {
            return false;
        }
        CookieSynchronizationConfiguration other = (CookieSynchronizationConfiguration) obj;
        return hasAllowlist() == other.hasAllowlist() && Objects.equals(allowlist(), other.allowlist())
                && hasBlocklist() == other.hasBlocklist() && Objects.equals(blocklist(), other.blocklist());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CookieSynchronizationConfiguration").add("Allowlist", hasAllowlist() ? allowlist() : null)
                .add("Blocklist", hasBlocklist() ? blocklist() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowlist":
            return Optional.ofNullable(clazz.cast(allowlist()));
        case "blocklist":
            return Optional.ofNullable(clazz.cast(blocklist()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowlist", ALLOWLIST_FIELD);
        map.put("blocklist", BLOCKLIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CookieSynchronizationConfiguration, T> g) {
        return obj -> g.apply((CookieSynchronizationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CookieSynchronizationConfiguration> {
        /**
         * <p>
         * The list of cookie specifications that are allowed to be synchronized to the remote browser.
         * </p>
         * 
         * @param allowlist
         *        The list of cookie specifications that are allowed to be synchronized to the remote browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowlist(Collection<CookieSpecification> allowlist);

        /**
         * <p>
         * The list of cookie specifications that are allowed to be synchronized to the remote browser.
         * </p>
         * 
         * @param allowlist
         *        The list of cookie specifications that are allowed to be synchronized to the remote browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowlist(CookieSpecification... allowlist);

        /**
         * <p>
         * The list of cookie specifications that are allowed to be synchronized to the remote browser.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #allowlist(List<CookieSpecification>)}.
         * 
         * @param allowlist
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowlist(java.util.Collection<CookieSpecification>)
         */
        Builder allowlist(Consumer<CookieSpecification.Builder>... allowlist);

        /**
         * <p>
         * The list of cookie specifications that are blocked from being synchronized to the remote browser.
         * </p>
         * 
         * @param blocklist
         *        The list of cookie specifications that are blocked from being synchronized to the remote browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocklist(Collection<CookieSpecification> blocklist);

        /**
         * <p>
         * The list of cookie specifications that are blocked from being synchronized to the remote browser.
         * </p>
         * 
         * @param blocklist
         *        The list of cookie specifications that are blocked from being synchronized to the remote browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocklist(CookieSpecification... blocklist);

        /**
         * <p>
         * The list of cookie specifications that are blocked from being synchronized to the remote browser.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #blocklist(List<CookieSpecification>)}.
         * 
         * @param blocklist
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.CookieSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blocklist(java.util.Collection<CookieSpecification>)
         */
        Builder blocklist(Consumer<CookieSpecification.Builder>... blocklist);
    }

    static final class BuilderImpl implements Builder {
        private List<CookieSpecification> allowlist = DefaultSdkAutoConstructList.getInstance();

        private List<CookieSpecification> blocklist = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieSynchronizationConfiguration model) {
            allowlist(model.allowlist);
            blocklist(model.blocklist);
        }

        public final List<CookieSpecification.Builder> getAllowlist() {
            List<CookieSpecification.Builder> result = CookieSpecificationsCopier.copyToBuilder(this.allowlist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowlist(Collection<CookieSpecification.BuilderImpl> allowlist) {
            this.allowlist = CookieSpecificationsCopier.copyFromBuilder(allowlist);
        }

        @Override
        public final Builder allowlist(Collection<CookieSpecification> allowlist) {
            this.allowlist = CookieSpecificationsCopier.copy(allowlist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowlist(CookieSpecification... allowlist) {
            allowlist(Arrays.asList(allowlist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowlist(Consumer<CookieSpecification.Builder>... allowlist) {
            allowlist(Stream.of(allowlist).map(c -> CookieSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CookieSpecification.Builder> getBlocklist() {
            List<CookieSpecification.Builder> result = CookieSpecificationsCopier.copyToBuilder(this.blocklist);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocklist(Collection<CookieSpecification.BuilderImpl> blocklist) {
            this.blocklist = CookieSpecificationsCopier.copyFromBuilder(blocklist);
        }

        @Override
        public final Builder blocklist(Collection<CookieSpecification> blocklist) {
            this.blocklist = CookieSpecificationsCopier.copy(blocklist);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(CookieSpecification... blocklist) {
            blocklist(Arrays.asList(blocklist));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocklist(Consumer<CookieSpecification.Builder>... blocklist) {
            blocklist(Stream.of(blocklist).map(c -> CookieSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CookieSynchronizationConfiguration build() {
            return new CookieSynchronizationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
