/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePortalRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdatePortalRequest.Builder, UpdatePortalRequest> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(UpdatePortalRequest::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdatePortalRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(UpdatePortalRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrentSessions").getter(getter(UpdatePortalRequest::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentSessions").build())
            .build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(UpdatePortalRequest::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("portalArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            DISPLAY_NAME_FIELD, INSTANCE_TYPE_FIELD, MAX_CONCURRENT_SESSIONS_FIELD, PORTAL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationType;

    private final String displayName;

    private final String instanceType;

    private final Integer maxConcurrentSessions;

    private final String portalArn;

    private UpdatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationType = builder.authenticationType;
        this.displayName = builder.displayName;
        this.instanceType = builder.instanceType;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.portalArn = builder.portalArn;
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
     * (including external identity provider integration), plus user and group access to your web portal, can be
     * configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
     *         sources (including external identity provider integration), plus user and group access to your web
     *         portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
     * (including external identity provider integration), plus user and group access to your web portal, can be
     * configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
     *         sources (including external identity provider integration), plus user and group access to your web
     *         portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The name of the web portal. This is not visible to users who log into the web portal.
     * </p>
     * 
     * @return The name of the web portal. This is not visible to users who log into the web portal.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum number of concurrent sessions for the portal.
     * </p>
     * 
     * @return The maximum number of concurrent sessions for the portal.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortalRequest)) {
            return false;
        }
        UpdatePortalRequest other = (UpdatePortalRequest) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions())
                && Objects.equals(portalArn(), other.portalArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePortalRequest").add("AuthenticationType", authenticationTypeAsString())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InstanceType", instanceTypeAsString()).add("MaxConcurrentSessions", maxConcurrentSessions())
                .add("PortalArn", portalArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "maxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("maxConcurrentSessions", MAX_CONCURRENT_SESSIONS_FIELD);
        map.put("portalArn", PORTAL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortalRequest, T> g) {
        return obj -> g.apply((UpdatePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePortalRequest> {
        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
         * (including external identity provider integration), plus user and group access to your web portal, can be
         * configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
         *        sources (including external identity provider integration), plus user and group access to your web
         *        portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
         * (including external identity provider integration), plus user and group access to your web portal, can be
         * configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
         *        sources (including external identity provider integration), plus user and group access to your web
         *        portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The name of the web portal. This is not visible to users who log into the web portal.
         * </p>
         * 
         * @param displayName
         *        The name of the web portal. This is not visible to users who log into the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum number of concurrent sessions for the portal.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum number of concurrent sessions for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);

        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String authenticationType;

        private String displayName;

        private String instanceType;

        private Integer maxConcurrentSessions;

        private String portalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortalRequest model) {
            super(model);
            authenticationType(model.authenticationType);
            displayName(model.displayName);
            instanceType(model.instanceType);
            maxConcurrentSessions(model.maxConcurrentSessions);
            portalArn(model.portalArn);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortalRequest build() {
            return new UpdatePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
