/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A network settings resource that can be associated with a web portal. Once associated with a web portal, network
 * settings define how streaming instances will connect with your specified VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkSettings implements SdkPojo, Serializable, ToCopyableBuilder<NetworkSettings.Builder, NetworkSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(NetworkSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(NetworkSettings::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(NetworkSettings::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(NetworkSettings::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(NetworkSettings::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD,
            NETWORK_SETTINGS_ARN_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> associatedPortalArns;

    private final String networkSettingsArn;

    private final List<String> securityGroupIds;

    private final List<String> subnetIds;

    private final String vpcId;

    private NetworkSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.networkSettingsArn = builder.networkSettingsArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this network settings is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this network settings is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * The ARN of the network settings.
     * </p>
     * 
     * @return The ARN of the network settings.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security groups used to control access from streaming instances to your VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return One or more security groups used to control access from streaming instances to your VPC.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two of
     * these subnets must be in different availability zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The subnets in which network interfaces are created to connect streaming instances to your VPC. At least
     *         two of these subnets must be in different availability zones.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The VPC that streaming instances will connect to.
     * </p>
     * 
     * @return The VPC that streaming instances will connect to.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSettings)) {
            return false;
        }
        NetworkSettings other = (NetworkSettings) obj;
        return hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(networkSettingsArn(), other.networkSettingsArn())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkSettings")
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("NetworkSettingsArn", networkSettingsArn())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("networkSettingsArn", NETWORK_SETTINGS_ARN_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkSettings, T> g) {
        return obj -> g.apply((NetworkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkSettings> {
        /**
         * <p>
         * A list of web portal ARNs that this network settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this network settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this network settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this network settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * The ARN of the network settings.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        /**
         * <p>
         * One or more security groups used to control access from streaming instances to your VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security groups used to control access from streaming instances to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more security groups used to control access from streaming instances to your VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security groups used to control access from streaming instances to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two
         * of these subnets must be in different availability zones.
         * </p>
         * 
         * @param subnetIds
         *        The subnets in which network interfaces are created to connect streaming instances to your VPC. At
         *        least two of these subnets must be in different availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The subnets in which network interfaces are created to connect streaming instances to your VPC. At least two
         * of these subnets must be in different availability zones.
         * </p>
         * 
         * @param subnetIds
         *        The subnets in which network interfaces are created to connect streaming instances to your VPC. At
         *        least two of these subnets must be in different availability zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The VPC that streaming instances will connect to.
         * </p>
         * 
         * @param vpcId
         *        The VPC that streaming instances will connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private String networkSettingsArn;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSettings model) {
            associatedPortalArns(model.associatedPortalArns);
            networkSettingsArn(model.networkSettingsArn);
            securityGroupIds(model.securityGroupIds);
            subnetIds(model.subnetIds);
            vpcId(model.vpcId);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public NetworkSettings build() {
            return new NetworkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
