/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.FolderStructure;
import software.amazon.awssdk.services.workspacesweb.model.LogFileFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3LogConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucket").getter(S3LogConfiguration.getter(S3LogConfiguration::bucket)).setter(S3LogConfiguration.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()}).build();
    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyPrefix").getter(S3LogConfiguration.getter(S3LogConfiguration::keyPrefix)).setter(S3LogConfiguration.setter(Builder::keyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()}).build();
    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketOwner").getter(S3LogConfiguration.getter(S3LogConfiguration::bucketOwner)).setter(S3LogConfiguration.setter(Builder::bucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwner").build()}).build();
    private static final SdkField<String> LOG_FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logFileFormat").getter(S3LogConfiguration.getter(S3LogConfiguration::logFileFormatAsString)).setter(S3LogConfiguration.setter(Builder::logFileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFileFormat").build()}).build();
    private static final SdkField<String> FOLDER_STRUCTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("folderStructure").getter(S3LogConfiguration.getter(S3LogConfiguration::folderStructureAsString)).setter(S3LogConfiguration.setter(Builder::folderStructure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderStructure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_PREFIX_FIELD, BUCKET_OWNER_FIELD, LOG_FILE_FORMAT_FIELD, FOLDER_STRUCTURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3LogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String keyPrefix;
    private final String bucketOwner;
    private final String logFileFormat;
    private final String folderStructure;

    private S3LogConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.bucketOwner = builder.bucketOwner;
        this.logFileFormat = builder.logFileFormat;
        this.folderStructure = builder.folderStructure;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String keyPrefix() {
        return this.keyPrefix;
    }

    public final String bucketOwner() {
        return this.bucketOwner;
    }

    public final LogFileFormat logFileFormat() {
        return LogFileFormat.fromValue(this.logFileFormat);
    }

    public final String logFileFormatAsString() {
        return this.logFileFormat;
    }

    public final FolderStructure folderStructure() {
        return FolderStructure.fromValue(this.folderStructure);
    }

    public final String folderStructureAsString() {
        return this.folderStructure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.folderStructureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogConfiguration)) {
            return false;
        }
        S3LogConfiguration other = (S3LogConfiguration)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyPrefix(), other.keyPrefix()) && Objects.equals(this.bucketOwner(), other.bucketOwner()) && Objects.equals(this.logFileFormatAsString(), other.logFileFormatAsString()) && Objects.equals(this.folderStructureAsString(), other.folderStructureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3LogConfiguration").add("Bucket", (Object)(this.bucket() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyPrefix", (Object)(this.keyPrefix() == null ? null : "*** Sensitive Data Redacted ***")).add("BucketOwner", (Object)this.bucketOwner()).add("LogFileFormat", (Object)this.logFileFormatAsString()).add("FolderStructure", (Object)this.folderStructureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "keyPrefix": {
                return Optional.ofNullable(clazz.cast(this.keyPrefix()));
            }
            case "bucketOwner": {
                return Optional.ofNullable(clazz.cast(this.bucketOwner()));
            }
            case "logFileFormat": {
                return Optional.ofNullable(clazz.cast(this.logFileFormatAsString()));
            }
            case "folderStructure": {
                return Optional.ofNullable(clazz.cast(this.folderStructureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bucket", BUCKET_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        map.put("bucketOwner", BUCKET_OWNER_FIELD);
        map.put("logFileFormat", LOG_FILE_FORMAT_FIELD);
        map.put("folderStructure", FOLDER_STRUCTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3LogConfiguration, T> g) {
        return obj -> g.apply((S3LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String keyPrefix;
        private String bucketOwner;
        private String logFileFormat;
        private String folderStructure;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogConfiguration model) {
            this.bucket(model.bucket);
            this.keyPrefix(model.keyPrefix);
            this.bucketOwner(model.bucketOwner);
            this.logFileFormat(model.logFileFormat);
            this.folderStructure(model.folderStructure);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getBucketOwner() {
            return this.bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public final String getLogFileFormat() {
            return this.logFileFormat;
        }

        public final void setLogFileFormat(String logFileFormat) {
            this.logFileFormat = logFileFormat;
        }

        @Override
        public final Builder logFileFormat(String logFileFormat) {
            this.logFileFormat = logFileFormat;
            return this;
        }

        @Override
        public final Builder logFileFormat(LogFileFormat logFileFormat) {
            this.logFileFormat(logFileFormat == null ? null : logFileFormat.toString());
            return this;
        }

        public final String getFolderStructure() {
            return this.folderStructure;
        }

        public final void setFolderStructure(String folderStructure) {
            this.folderStructure = folderStructure;
        }

        @Override
        public final Builder folderStructure(String folderStructure) {
            this.folderStructure = folderStructure;
            return this;
        }

        @Override
        public final Builder folderStructure(FolderStructure folderStructure) {
            this.folderStructure(folderStructure == null ? null : folderStructure.toString());
            return this;
        }

        public S3LogConfiguration build() {
            return new S3LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3LogConfiguration> {
        public Builder bucket(String var1);

        public Builder keyPrefix(String var1);

        public Builder bucketOwner(String var1);

        public Builder logFileFormat(String var1);

        public Builder logFileFormat(LogFileFormat var1);

        public Builder folderStructure(String var1);

        public Builder folderStructure(FolderStructure var1);
    }
}

