/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionLoggersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListSessionLoggersResponse;
import software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary;

public class ListSessionLoggersPublisher
implements SdkPublisher<ListSessionLoggersResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListSessionLoggersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionLoggersPublisher(WorkSpacesWebAsyncClient client, ListSessionLoggersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionLoggersPublisher(WorkSpacesWebAsyncClient client, ListSessionLoggersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionLoggersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionLoggersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SessionLoggerSummary> sessionLoggers() {
        Function<ListSessionLoggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionLoggers() != null) {
                return response.sessionLoggers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSessionLoggersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSessionLoggersResponseFetcher
    implements AsyncPageFetcher<ListSessionLoggersResponse> {
        private ListSessionLoggersResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionLoggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionLoggersResponse> nextPage(ListSessionLoggersResponse previousPage) {
            if (previousPage == null) {
                return ListSessionLoggersPublisher.this.client.listSessionLoggers(ListSessionLoggersPublisher.this.firstRequest);
            }
            return ListSessionLoggersPublisher.this.client.listSessionLoggers((ListSessionLoggersRequest)((Object)ListSessionLoggersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

