/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.LogConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionLoggerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionLoggerSummary> {
    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionLoggerArn").getter(SessionLoggerSummary.getter(SessionLoggerSummary::sessionLoggerArn)).setter(SessionLoggerSummary.setter(Builder::sessionLoggerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggerArn").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(SessionLoggerSummary.getter(SessionLoggerSummary::logConfiguration)).setter(SessionLoggerSummary.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(SessionLoggerSummary.getter(SessionLoggerSummary::displayName)).setter(SessionLoggerSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(SessionLoggerSummary.getter(SessionLoggerSummary::creationDate)).setter(SessionLoggerSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_ARN_FIELD, LOG_CONFIGURATION_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionLoggerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sessionLoggerArn;
    private final LogConfiguration logConfiguration;
    private final String displayName;
    private final Instant creationDate;

    private SessionLoggerSummary(BuilderImpl builder) {
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.logConfiguration = builder.logConfiguration;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
    }

    public final String sessionLoggerArn() {
        return this.sessionLoggerArn;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionLoggerSummary)) {
            return false;
        }
        SessionLoggerSummary other = (SessionLoggerSummary)obj;
        return Objects.equals(this.sessionLoggerArn(), other.sessionLoggerArn()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"SessionLoggerSummary").add("SessionLoggerArn", (Object)this.sessionLoggerArn()).add("LogConfiguration", (Object)this.logConfiguration()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionLoggerArn": {
                return Optional.ofNullable(clazz.cast(this.sessionLoggerArn()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionLoggerSummary, T> g) {
        return obj -> g.apply((SessionLoggerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sessionLoggerArn;
        private LogConfiguration logConfiguration;
        private String displayName;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionLoggerSummary model) {
            this.sessionLoggerArn(model.sessionLoggerArn);
            this.logConfiguration(model.logConfiguration);
            this.displayName(model.displayName);
            this.creationDate(model.creationDate);
        }

        public final String getSessionLoggerArn() {
            return this.sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public SessionLoggerSummary build() {
            return new SessionLoggerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionLoggerSummary> {
        public Builder sessionLoggerArn(String var1);

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder displayName(String var1);

        public Builder creationDate(Instant var1);
    }
}

