/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> THUMBPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thumbprint").getter(getter(Certificate::thumbprint)).setter(setter(Builder::thumbprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbprint").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(Certificate::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("issuer")
            .getter(getter(Certificate::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final SdkField<Instant> NOT_VALID_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("notValidBefore").getter(getter(Certificate::notValidBefore)).setter(setter(Builder::notValidBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidBefore").build()).build();

    private static final SdkField<Instant> NOT_VALID_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("notValidAfter").getter(getter(Certificate::notValidAfter)).setter(setter(Builder::notValidAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidAfter").build()).build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body").getter(getter(Certificate::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBPRINT_FIELD,
            SUBJECT_FIELD, ISSUER_FIELD, NOT_VALID_BEFORE_FIELD, NOT_VALID_AFTER_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thumbprint;

    private final String subject;

    private final String issuer;

    private final Instant notValidBefore;

    private final Instant notValidAfter;

    private final SdkBytes body;

    private Certificate(BuilderImpl builder) {
        this.thumbprint = builder.thumbprint;
        this.subject = builder.subject;
        this.issuer = builder.issuer;
        this.notValidBefore = builder.notValidBefore;
        this.notValidAfter = builder.notValidAfter;
        this.body = builder.body;
    }

    /**
     * <p>
     * A hexadecimal identifier for the certificate.
     * </p>
     * 
     * @return A hexadecimal identifier for the certificate.
     */
    public final String thumbprint() {
        return thumbprint;
    }

    /**
     * <p>
     * The entity the certificate belongs to.
     * </p>
     * 
     * @return The entity the certificate belongs to.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The entity that issued the certificate.
     * </p>
     * 
     * @return The entity that issued the certificate.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The certificate is not valid before this date.
     * </p>
     * 
     * @return The certificate is not valid before this date.
     */
    public final Instant notValidBefore() {
        return notValidBefore;
    }

    /**
     * <p>
     * The certificate is not valid after this date.
     * </p>
     * 
     * @return The certificate is not valid after this date.
     */
    public final Instant notValidAfter() {
        return notValidAfter;
    }

    /**
     * <p>
     * The body of the certificate.
     * </p>
     * 
     * @return The body of the certificate.
     */
    public final SdkBytes body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thumbprint());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(notValidBefore());
        hashCode = 31 * hashCode + Objects.hashCode(notValidAfter());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(thumbprint(), other.thumbprint()) && Objects.equals(subject(), other.subject())
                && Objects.equals(issuer(), other.issuer()) && Objects.equals(notValidBefore(), other.notValidBefore())
                && Objects.equals(notValidAfter(), other.notValidAfter()) && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("Thumbprint", thumbprint()).add("Subject", subject()).add("Issuer", issuer())
                .add("NotValidBefore", notValidBefore()).add("NotValidAfter", notValidAfter()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thumbprint":
            return Optional.ofNullable(clazz.cast(thumbprint()));
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "notValidBefore":
            return Optional.ofNullable(clazz.cast(notValidBefore()));
        case "notValidAfter":
            return Optional.ofNullable(clazz.cast(notValidAfter()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thumbprint", THUMBPRINT_FIELD);
        map.put("subject", SUBJECT_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("notValidBefore", NOT_VALID_BEFORE_FIELD);
        map.put("notValidAfter", NOT_VALID_AFTER_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * A hexadecimal identifier for the certificate.
         * </p>
         * 
         * @param thumbprint
         *        A hexadecimal identifier for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprint(String thumbprint);

        /**
         * <p>
         * The entity the certificate belongs to.
         * </p>
         * 
         * @param subject
         *        The entity the certificate belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The entity that issued the certificate.
         * </p>
         * 
         * @param issuer
         *        The entity that issued the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The certificate is not valid before this date.
         * </p>
         * 
         * @param notValidBefore
         *        The certificate is not valid before this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notValidBefore(Instant notValidBefore);

        /**
         * <p>
         * The certificate is not valid after this date.
         * </p>
         * 
         * @param notValidAfter
         *        The certificate is not valid after this date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notValidAfter(Instant notValidAfter);

        /**
         * <p>
         * The body of the certificate.
         * </p>
         * 
         * @param body
         *        The body of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);
    }

    static final class BuilderImpl implements Builder {
        private String thumbprint;

        private String subject;

        private String issuer;

        private Instant notValidBefore;

        private Instant notValidAfter;

        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            thumbprint(model.thumbprint);
            subject(model.subject);
            issuer(model.issuer);
            notValidBefore(model.notValidBefore);
            notValidAfter(model.notValidAfter);
            body(model.body);
        }

        public final String getThumbprint() {
            return thumbprint;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        @Override
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final Instant getNotValidBefore() {
            return notValidBefore;
        }

        public final void setNotValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
        }

        @Override
        public final Builder notValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
            return this;
        }

        public final Instant getNotValidAfter() {
            return notValidAfter;
        }

        public final void setNotValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
        }

        @Override
        public final Builder notValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
            return this;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
