/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the data protection settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProtectionSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProtectionSettingsSummary.Builder, DataProtectionSettingsSummary> {
    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProtectionSettingsArn").getter(getter(DataProtectionSettingsSummary::dataProtectionSettingsArn))
            .setter(setter(Builder::dataProtectionSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProtectionSettingsArn").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(DataProtectionSettingsSummary::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DataProtectionSettingsSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DataProtectionSettingsSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_PROTECTION_SETTINGS_ARN_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataProtectionSettingsArn;

    private final String displayName;

    private final String description;

    private final Instant creationDate;

    private DataProtectionSettingsSummary(BuilderImpl builder) {
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN of the data protection settings.
     * </p>
     * 
     * @return The ARN of the data protection settings.
     */
    public final String dataProtectionSettingsArn() {
        return dataProtectionSettingsArn;
    }

    /**
     * <p>
     * The display name of the data protection settings.
     * </p>
     * 
     * @return The display name of the data protection settings.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the data protection settings.
     * </p>
     * 
     * @return The description of the data protection settings.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The creation date timestamp of the data protection settings.
     * </p>
     * 
     * @return The creation date timestamp of the data protection settings.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProtectionSettingsSummary)) {
            return false;
        }
        DataProtectionSettingsSummary other = (DataProtectionSettingsSummary) obj;
        return Objects.equals(dataProtectionSettingsArn(), other.dataProtectionSettingsArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProtectionSettingsSummary").add("DataProtectionSettingsArn", dataProtectionSettingsArn())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataProtectionSettingsArn":
            return Optional.ofNullable(clazz.cast(dataProtectionSettingsArn()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProtectionSettingsSummary, T> g) {
        return obj -> g.apply((DataProtectionSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProtectionSettingsSummary> {
        /**
         * <p>
         * The ARN of the data protection settings.
         * </p>
         * 
         * @param dataProtectionSettingsArn
         *        The ARN of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionSettingsArn(String dataProtectionSettingsArn);

        /**
         * <p>
         * The display name of the data protection settings.
         * </p>
         * 
         * @param displayName
         *        The display name of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the data protection settings.
         * </p>
         * 
         * @param description
         *        The description of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The creation date timestamp of the data protection settings.
         * </p>
         * 
         * @param creationDate
         *        The creation date timestamp of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String dataProtectionSettingsArn;

        private String displayName;

        private String description;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProtectionSettingsSummary model) {
            dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            displayName(model.displayName);
            description(model.description);
            creationDate(model.creationDate);
        }

        public final String getDataProtectionSettingsArn() {
            return dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public DataProtectionSettingsSummary build() {
            return new DataProtectionSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
