/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIpAccessSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListIpAccessSettingsResponse.Builder, ListIpAccessSettingsResponse> {
    private static final SdkField<List<IpAccessSettingsSummary>> IP_ACCESS_SETTINGS_FIELD = SdkField
            .<List<IpAccessSettingsSummary>> builder(MarshallingType.LIST)
            .memberName("ipAccessSettings")
            .getter(getter(ListIpAccessSettingsResponse::ipAccessSettings))
            .setter(setter(Builder::ipAccessSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpAccessSettingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpAccessSettingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIpAccessSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ACCESS_SETTINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IpAccessSettingsSummary> ipAccessSettings;

    private final String nextToken;

    private ListIpAccessSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.ipAccessSettings = builder.ipAccessSettings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpAccessSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpAccessSettings() {
        return ipAccessSettings != null && !(ipAccessSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP access settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpAccessSettings} method.
     * </p>
     * 
     * @return The IP access settings.
     */
    public final List<IpAccessSettingsSummary> ipAccessSettings() {
        return ipAccessSettings;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAccessSettings() ? ipAccessSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpAccessSettingsResponse)) {
            return false;
        }
        ListIpAccessSettingsResponse other = (ListIpAccessSettingsResponse) obj;
        return hasIpAccessSettings() == other.hasIpAccessSettings()
                && Objects.equals(ipAccessSettings(), other.ipAccessSettings()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIpAccessSettingsResponse")
                .add("IpAccessSettings", hasIpAccessSettings() ? ipAccessSettings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAccessSettings":
            return Optional.ofNullable(clazz.cast(ipAccessSettings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ipAccessSettings", IP_ACCESS_SETTINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIpAccessSettingsResponse, T> g) {
        return obj -> g.apply((ListIpAccessSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIpAccessSettingsResponse> {
        /**
         * <p>
         * The IP access settings.
         * </p>
         * 
         * @param ipAccessSettings
         *        The IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettings(Collection<IpAccessSettingsSummary> ipAccessSettings);

        /**
         * <p>
         * The IP access settings.
         * </p>
         * 
         * @param ipAccessSettings
         *        The IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettings(IpAccessSettingsSummary... ipAccessSettings);

        /**
         * <p>
         * The IP access settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #ipAccessSettings(List<IpAccessSettingsSummary>)}.
         * 
         * @param ipAccessSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.IpAccessSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAccessSettings(java.util.Collection<IpAccessSettingsSummary>)
         */
        Builder ipAccessSettings(Consumer<IpAccessSettingsSummary.Builder>... ipAccessSettings);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<IpAccessSettingsSummary> ipAccessSettings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpAccessSettingsResponse model) {
            super(model);
            ipAccessSettings(model.ipAccessSettings);
            nextToken(model.nextToken);
        }

        public final List<IpAccessSettingsSummary.Builder> getIpAccessSettings() {
            List<IpAccessSettingsSummary.Builder> result = IpAccessSettingsListCopier.copyToBuilder(this.ipAccessSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpAccessSettings(Collection<IpAccessSettingsSummary.BuilderImpl> ipAccessSettings) {
            this.ipAccessSettings = IpAccessSettingsListCopier.copyFromBuilder(ipAccessSettings);
        }

        @Override
        public final Builder ipAccessSettings(Collection<IpAccessSettingsSummary> ipAccessSettings) {
            this.ipAccessSettings = IpAccessSettingsListCopier.copy(ipAccessSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAccessSettings(IpAccessSettingsSummary... ipAccessSettings) {
            ipAccessSettings(Arrays.asList(ipAccessSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAccessSettings(Consumer<IpAccessSettingsSummary.Builder>... ipAccessSettings) {
            ipAccessSettings(Stream.of(ipAccessSettings).map(c -> IpAccessSettingsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIpAccessSettingsResponse build() {
            return new ListIpAccessSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
