/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionLoggersResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListSessionLoggersResponse.Builder, ListSessionLoggersResponse> {
    private static final SdkField<List<SessionLoggerSummary>> SESSION_LOGGERS_FIELD = SdkField
            .<List<SessionLoggerSummary>> builder(MarshallingType.LIST)
            .memberName("sessionLoggers")
            .getter(getter(ListSessionLoggersResponse::sessionLoggers))
            .setter(setter(Builder::sessionLoggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SessionLoggerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SessionLoggerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSessionLoggersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SessionLoggerSummary> sessionLoggers;

    private final String nextToken;

    private ListSessionLoggersResponse(BuilderImpl builder) {
        super(builder);
        this.sessionLoggers = builder.sessionLoggers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionLoggers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionLoggers() {
        return sessionLoggers != null && !(sessionLoggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of session loggers, including summaries of their details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionLoggers} method.
     * </p>
     * 
     * @return The list of session loggers, including summaries of their details.
     */
    public final List<SessionLoggerSummary> sessionLoggers() {
        return sessionLoggers;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionLoggers() ? sessionLoggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionLoggersResponse)) {
            return false;
        }
        ListSessionLoggersResponse other = (ListSessionLoggersResponse) obj;
        return hasSessionLoggers() == other.hasSessionLoggers() && Objects.equals(sessionLoggers(), other.sessionLoggers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionLoggersResponse")
                .add("SessionLoggers", hasSessionLoggers() ? sessionLoggers() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionLoggers":
            return Optional.ofNullable(clazz.cast(sessionLoggers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionLoggers", SESSION_LOGGERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionLoggersResponse, T> g) {
        return obj -> g.apply((ListSessionLoggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSessionLoggersResponse> {
        /**
         * <p>
         * The list of session loggers, including summaries of their details.
         * </p>
         * 
         * @param sessionLoggers
         *        The list of session loggers, including summaries of their details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggers(Collection<SessionLoggerSummary> sessionLoggers);

        /**
         * <p>
         * The list of session loggers, including summaries of their details.
         * </p>
         * 
         * @param sessionLoggers
         *        The list of session loggers, including summaries of their details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggers(SessionLoggerSummary... sessionLoggers);

        /**
         * <p>
         * The list of session loggers, including summaries of their details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #sessionLoggers(List<SessionLoggerSummary>)}.
         * 
         * @param sessionLoggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.SessionLoggerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionLoggers(java.util.Collection<SessionLoggerSummary>)
         */
        Builder sessionLoggers(Consumer<SessionLoggerSummary.Builder>... sessionLoggers);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<SessionLoggerSummary> sessionLoggers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionLoggersResponse model) {
            super(model);
            sessionLoggers(model.sessionLoggers);
            nextToken(model.nextToken);
        }

        public final List<SessionLoggerSummary.Builder> getSessionLoggers() {
            List<SessionLoggerSummary.Builder> result = SessionLoggerListCopier.copyToBuilder(this.sessionLoggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionLoggers(Collection<SessionLoggerSummary.BuilderImpl> sessionLoggers) {
            this.sessionLoggers = SessionLoggerListCopier.copyFromBuilder(sessionLoggers);
        }

        @Override
        public final Builder sessionLoggers(Collection<SessionLoggerSummary> sessionLoggers) {
            this.sessionLoggers = SessionLoggerListCopier.copy(sessionLoggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionLoggers(SessionLoggerSummary... sessionLoggers) {
            sessionLoggers(Arrays.asList(sessionLoggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionLoggers(Consumer<SessionLoggerSummary.Builder>... sessionLoggers) {
            sessionLoggers(Stream.of(sessionLoggers).map(c -> SessionLoggerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSessionLoggersResponse build() {
            return new ListSessionLoggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
