/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Portal implements SdkPojo, Serializable, ToCopyableBuilder<Portal.Builder, Portal> {
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(Portal::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> RENDERER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rendererType").getter(getter(Portal::rendererTypeAsString)).setter(setter(Builder::rendererType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rendererType").build()).build();

    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserType").getter(getter(Portal::browserTypeAsString)).setter(setter(Builder::browserType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserType").build()).build();

    private static final SdkField<String> PORTAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalStatus").getter(getter(Portal::portalStatusAsString)).setter(setter(Builder::portalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalEndpoint").getter(getter(Portal::portalEndpoint)).setter(setter(Builder::portalEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Portal::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(Portal::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(Portal::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build())
            .build();

    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProtectionSettingsArn").getter(getter(Portal::dataProtectionSettingsArn))
            .setter(setter(Builder::dataProtectionSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProtectionSettingsArn").build())
            .build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(Portal::userSettingsArn)).setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()).build();

    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(Portal::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build())
            .build();

    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionLoggerArn").getter(getter(Portal::sessionLoggerArn)).setter(setter(Builder::sessionLoggerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggerArn").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustStoreArn").getter(getter(Portal::trustStoreArn)).setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(Portal::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(Portal::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(Portal::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAccessSettingsArn").getter(getter(Portal::ipAccessSettingsArn))
            .setter(setter(Builder::ipAccessSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build())
            .build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(Portal::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(Portal::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(Portal::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrentSessions").getter(getter(Portal::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentSessions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ARN_FIELD,
            RENDERER_TYPE_FIELD, BROWSER_TYPE_FIELD, PORTAL_STATUS_FIELD, PORTAL_ENDPOINT_FIELD, DISPLAY_NAME_FIELD,
            CREATION_DATE_FIELD, BROWSER_SETTINGS_ARN_FIELD, DATA_PROTECTION_SETTINGS_ARN_FIELD, USER_SETTINGS_ARN_FIELD,
            NETWORK_SETTINGS_ARN_FIELD, SESSION_LOGGER_ARN_FIELD, TRUST_STORE_ARN_FIELD, STATUS_REASON_FIELD,
            USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD, AUTHENTICATION_TYPE_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD,
            CUSTOMER_MANAGED_KEY_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, INSTANCE_TYPE_FIELD, MAX_CONCURRENT_SESSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String portalArn;

    private final String rendererType;

    private final String browserType;

    private final String portalStatus;

    private final String portalEndpoint;

    private final String displayName;

    private final Instant creationDate;

    private final String browserSettingsArn;

    private final String dataProtectionSettingsArn;

    private final String userSettingsArn;

    private final String networkSettingsArn;

    private final String sessionLoggerArn;

    private final String trustStoreArn;

    private final String statusReason;

    private final String userAccessLoggingSettingsArn;

    private final String authenticationType;

    private final String ipAccessSettingsArn;

    private final String customerManagedKey;

    private final Map<String, String> additionalEncryptionContext;

    private final String instanceType;

    private final Integer maxConcurrentSessions;

    private Portal(BuilderImpl builder) {
        this.portalArn = builder.portalArn;
        this.rendererType = builder.rendererType;
        this.browserType = builder.browserType;
        this.portalStatus = builder.portalStatus;
        this.portalEndpoint = builder.portalEndpoint;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.userSettingsArn = builder.userSettingsArn;
        this.networkSettingsArn = builder.networkSettingsArn;
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.trustStoreArn = builder.trustStoreArn;
        this.statusReason = builder.statusReason;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
        this.authenticationType = builder.authenticationType;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.customerManagedKey = builder.customerManagedKey;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.instanceType = builder.instanceType;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final RendererType rendererType() {
        return RendererType.fromValue(rendererType);
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final String rendererTypeAsString() {
        return rendererType;
    }

    /**
     * <p>
     * The browser that users see when using a streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser that users see when using a streaming session.
     * @see BrowserType
     */
    public final BrowserType browserType() {
        return BrowserType.fromValue(browserType);
    }

    /**
     * <p>
     * The browser that users see when using a streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser that users see when using a streaming session.
     * @see BrowserType
     */
    public final String browserTypeAsString() {
        return browserType;
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final PortalStatus portalStatus() {
        return PortalStatus.fromValue(portalStatus);
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final String portalStatusAsString() {
        return portalStatus;
    }

    /**
     * <p>
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     * </p>
     * 
     * @return The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    public final String portalEndpoint() {
        return portalEndpoint;
    }

    /**
     * <p>
     * The name of the web portal.
     * </p>
     * 
     * @return The name of the web portal.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The creation date of the web portal.
     * </p>
     * 
     * @return The creation date of the web portal.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The ARN of the browser settings that is associated with this web portal.
     * </p>
     * 
     * @return The ARN of the browser settings that is associated with this web portal.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    /**
     * <p>
     * The ARN of the data protection settings.
     * </p>
     * 
     * @return The ARN of the data protection settings.
     */
    public final String dataProtectionSettingsArn() {
        return dataProtectionSettingsArn;
    }

    /**
     * <p>
     * The ARN of the user settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user settings that is associated with the web portal.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    /**
     * <p>
     * The ARN of the network settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the network settings that is associated with the web portal.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    /**
     * <p>
     * The ARN of the session logger that is assocaited with the portal.
     * </p>
     * 
     * @return The ARN of the session logger that is assocaited with the portal.
     */
    public final String sessionLoggerArn() {
        return sessionLoggerArn;
    }

    /**
     * <p>
     * The ARN of the trust store that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the trust store that is associated with the web portal.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * A message that explains why the web portal is in its current status.
     * </p>
     * 
     * @return A message that explains why the web portal is in its current status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The ARN of the user access logging settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user access logging settings that is associated with the web portal.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
     * (including external identity provider integration), plus user and group access to your web portal, can be
     * configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
     *         sources (including external identity provider integration), plus user and group access to your web
     *         portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
     * (including external identity provider integration), plus user and group access to your web portal, can be
     * configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
     *         sources (including external identity provider integration), plus user and group access to your web
     *         portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     * 
     * @return The ARN of the IP access settings.
     */
    public final String ipAccessSettingsArn() {
        return ipAccessSettingsArn;
    }

    /**
     * <p>
     * The customer managed key used to encrypt sensitive information in the portal.
     * </p>
     * 
     * @return The customer managed key used to encrypt sensitive information in the portal.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the portal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the portal.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum number of concurrent sessions for the portal.
     * </p>
     * 
     * @return The maximum number of concurrent sessions for the portal.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(rendererTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(browserTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(portalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(portalEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Portal)) {
            return false;
        }
        Portal other = (Portal) obj;
        return Objects.equals(portalArn(), other.portalArn())
                && Objects.equals(rendererTypeAsString(), other.rendererTypeAsString())
                && Objects.equals(browserTypeAsString(), other.browserTypeAsString())
                && Objects.equals(portalStatusAsString(), other.portalStatusAsString())
                && Objects.equals(portalEndpoint(), other.portalEndpoint()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(browserSettingsArn(), other.browserSettingsArn())
                && Objects.equals(dataProtectionSettingsArn(), other.dataProtectionSettingsArn())
                && Objects.equals(userSettingsArn(), other.userSettingsArn())
                && Objects.equals(networkSettingsArn(), other.networkSettingsArn())
                && Objects.equals(sessionLoggerArn(), other.sessionLoggerArn())
                && Objects.equals(trustStoreArn(), other.trustStoreArn()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(ipAccessSettingsArn(), other.ipAccessSettingsArn())
                && Objects.equals(customerManagedKey(), other.customerManagedKey())
                && hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Portal").add("PortalArn", portalArn()).add("RendererType", rendererTypeAsString())
                .add("BrowserType", browserTypeAsString()).add("PortalStatus", portalStatusAsString())
                .add("PortalEndpoint", portalEndpoint())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationDate", creationDate()).add("BrowserSettingsArn", browserSettingsArn())
                .add("DataProtectionSettingsArn", dataProtectionSettingsArn()).add("UserSettingsArn", userSettingsArn())
                .add("NetworkSettingsArn", networkSettingsArn()).add("SessionLoggerArn", sessionLoggerArn())
                .add("TrustStoreArn", trustStoreArn()).add("StatusReason", statusReason())
                .add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn())
                .add("AuthenticationType", authenticationTypeAsString()).add("IpAccessSettingsArn", ipAccessSettingsArn())
                .add("CustomerManagedKey", customerManagedKey())
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("InstanceType", instanceTypeAsString()).add("MaxConcurrentSessions", maxConcurrentSessions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "rendererType":
            return Optional.ofNullable(clazz.cast(rendererTypeAsString()));
        case "browserType":
            return Optional.ofNullable(clazz.cast(browserTypeAsString()));
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatusAsString()));
        case "portalEndpoint":
            return Optional.ofNullable(clazz.cast(portalEndpoint()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        case "dataProtectionSettingsArn":
            return Optional.ofNullable(clazz.cast(dataProtectionSettingsArn()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        case "sessionLoggerArn":
            return Optional.ofNullable(clazz.cast(sessionLoggerArn()));
        case "trustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "ipAccessSettingsArn":
            return Optional.ofNullable(clazz.cast(ipAccessSettingsArn()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "maxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portalArn", PORTAL_ARN_FIELD);
        map.put("rendererType", RENDERER_TYPE_FIELD);
        map.put("browserType", BROWSER_TYPE_FIELD);
        map.put("portalStatus", PORTAL_STATUS_FIELD);
        map.put("portalEndpoint", PORTAL_ENDPOINT_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("browserSettingsArn", BROWSER_SETTINGS_ARN_FIELD);
        map.put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
        map.put("userSettingsArn", USER_SETTINGS_ARN_FIELD);
        map.put("networkSettingsArn", NETWORK_SETTINGS_ARN_FIELD);
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("userAccessLoggingSettingsArn", USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD);
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("maxConcurrentSessions", MAX_CONCURRENT_SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Portal, T> g) {
        return obj -> g.apply((Portal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Portal> {
        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(String rendererType);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(RendererType rendererType);

        /**
         * <p>
         * The browser that users see when using a streaming session.
         * </p>
         * 
         * @param browserType
         *        The browser that users see when using a streaming session.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(String browserType);

        /**
         * <p>
         * The browser that users see when using a streaming session.
         * </p>
         * 
         * @param browserType
         *        The browser that users see when using a streaming session.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(BrowserType browserType);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(String portalStatus);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The endpoint URL of the web portal that users access in order to start streaming sessions.
         * </p>
         * 
         * @param portalEndpoint
         *        The endpoint URL of the web portal that users access in order to start streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalEndpoint(String portalEndpoint);

        /**
         * <p>
         * The name of the web portal.
         * </p>
         * 
         * @param displayName
         *        The name of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The creation date of the web portal.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The ARN of the browser settings that is associated with this web portal.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings that is associated with this web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);

        /**
         * <p>
         * The ARN of the data protection settings.
         * </p>
         * 
         * @param dataProtectionSettingsArn
         *        The ARN of the data protection settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionSettingsArn(String dataProtectionSettingsArn);

        /**
         * <p>
         * The ARN of the user settings that is associated with the web portal.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);

        /**
         * <p>
         * The ARN of the network settings that is associated with the web portal.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        /**
         * <p>
         * The ARN of the session logger that is assocaited with the portal.
         * </p>
         * 
         * @param sessionLoggerArn
         *        The ARN of the session logger that is assocaited with the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggerArn(String sessionLoggerArn);

        /**
         * <p>
         * The ARN of the trust store that is associated with the web portal.
         * </p>
         * 
         * @param trustStoreArn
         *        The ARN of the trust store that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * A message that explains why the web portal is in its current status.
         * </p>
         * 
         * @param statusReason
         *        A message that explains why the web portal is in its current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The ARN of the user access logging settings that is associated with the web portal.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
         * (including external identity provider integration), plus user and group access to your web portal, can be
         * configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
         *        sources (including external identity provider integration), plus user and group access to your web
         *        portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity sources
         * (including external identity provider integration), plus user and group access to your web portal, can be
         * configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center. Identity
         *        sources (including external identity provider integration), plus user and group access to your web
         *        portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The ARN of the IP access settings.
         * </p>
         * 
         * @param ipAccessSettingsArn
         *        The ARN of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettingsArn(String ipAccessSettingsArn);

        /**
         * <p>
         * The customer managed key used to encrypt sensitive information in the portal.
         * </p>
         * 
         * @param customerManagedKey
         *        The customer managed key used to encrypt sensitive information in the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The additional encryption context of the portal.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum number of concurrent sessions for the portal.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum number of concurrent sessions for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);
    }

    static final class BuilderImpl implements Builder {
        private String portalArn;

        private String rendererType;

        private String browserType;

        private String portalStatus;

        private String portalEndpoint;

        private String displayName;

        private Instant creationDate;

        private String browserSettingsArn;

        private String dataProtectionSettingsArn;

        private String userSettingsArn;

        private String networkSettingsArn;

        private String sessionLoggerArn;

        private String trustStoreArn;

        private String statusReason;

        private String userAccessLoggingSettingsArn;

        private String authenticationType;

        private String ipAccessSettingsArn;

        private String customerManagedKey;

        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private String instanceType;

        private Integer maxConcurrentSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(Portal model) {
            portalArn(model.portalArn);
            rendererType(model.rendererType);
            browserType(model.browserType);
            portalStatus(model.portalStatus);
            portalEndpoint(model.portalEndpoint);
            displayName(model.displayName);
            creationDate(model.creationDate);
            browserSettingsArn(model.browserSettingsArn);
            dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            userSettingsArn(model.userSettingsArn);
            networkSettingsArn(model.networkSettingsArn);
            sessionLoggerArn(model.sessionLoggerArn);
            trustStoreArn(model.trustStoreArn);
            statusReason(model.statusReason);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
            authenticationType(model.authenticationType);
            ipAccessSettingsArn(model.ipAccessSettingsArn);
            customerManagedKey(model.customerManagedKey);
            additionalEncryptionContext(model.additionalEncryptionContext);
            instanceType(model.instanceType);
            maxConcurrentSessions(model.maxConcurrentSessions);
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getRendererType() {
            return rendererType;
        }

        public final void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }

        @Override
        public final Builder rendererType(String rendererType) {
            this.rendererType = rendererType;
            return this;
        }

        @Override
        public final Builder rendererType(RendererType rendererType) {
            this.rendererType(rendererType == null ? null : rendererType.toString());
            return this;
        }

        public final String getBrowserType() {
            return browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public final String getPortalStatus() {
            return portalStatus;
        }

        public final void setPortalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
        }

        @Override
        public final Builder portalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus(portalStatus == null ? null : portalStatus.toString());
            return this;
        }

        public final String getPortalEndpoint() {
            return portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getDataProtectionSettingsArn() {
            return dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final String getSessionLoggerArn() {
            return sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        @Override
        public Portal build() {
            return new Portal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
