/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 log configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3LogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3LogConfiguration.Builder, S3LogConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(S3LogConfiguration::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPrefix").getter(getter(S3LogConfiguration::keyPrefix)).setter(setter(Builder::keyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()).build();

    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwner").getter(getter(S3LogConfiguration::bucketOwner)).setter(setter(Builder::bucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwner").build()).build();

    private static final SdkField<String> LOG_FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logFileFormat").getter(getter(S3LogConfiguration::logFileFormatAsString))
            .setter(setter(Builder::logFileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFileFormat").build()).build();

    private static final SdkField<String> FOLDER_STRUCTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("folderStructure").getter(getter(S3LogConfiguration::folderStructureAsString))
            .setter(setter(Builder::folderStructure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderStructure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            KEY_PREFIX_FIELD, BUCKET_OWNER_FIELD, LOG_FILE_FORMAT_FIELD, FOLDER_STRUCTURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String keyPrefix;

    private final String bucketOwner;

    private final String logFileFormat;

    private final String folderStructure;

    private S3LogConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.bucketOwner = builder.bucketOwner;
        this.logFileFormat = builder.logFileFormat;
        this.folderStructure = builder.folderStructure;
    }

    /**
     * <p>
     * The S3 bucket name where logs are delivered.
     * </p>
     * 
     * @return The S3 bucket name where logs are delivered.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The S3 path prefix that determines where log files are stored.
     * </p>
     * 
     * @return The S3 path prefix that determines where log files are stored.
     */
    public final String keyPrefix() {
        return keyPrefix;
    }

    /**
     * <p>
     * The expected bucket owner of the target S3 bucket. The caller must have permissions to write to the target
     * bucket.
     * </p>
     * 
     * @return The expected bucket owner of the target S3 bucket. The caller must have permissions to write to the
     *         target bucket.
     */
    public final String bucketOwner() {
        return bucketOwner;
    }

    /**
     * <p>
     * The format of the LogFile that is written to S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFileFormat}
     * will return {@link LogFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFileFormatAsString}.
     * </p>
     * 
     * @return The format of the LogFile that is written to S3.
     * @see LogFileFormat
     */
    public final LogFileFormat logFileFormat() {
        return LogFileFormat.fromValue(logFileFormat);
    }

    /**
     * <p>
     * The format of the LogFile that is written to S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFileFormat}
     * will return {@link LogFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFileFormatAsString}.
     * </p>
     * 
     * @return The format of the LogFile that is written to S3.
     * @see LogFileFormat
     */
    public final String logFileFormatAsString() {
        return logFileFormat;
    }

    /**
     * <p>
     * The folder structure that defines the organizational structure for log files in S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderStructure}
     * will return {@link FolderStructure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #folderStructureAsString}.
     * </p>
     * 
     * @return The folder structure that defines the organizational structure for log files in S3.
     * @see FolderStructure
     */
    public final FolderStructure folderStructure() {
        return FolderStructure.fromValue(folderStructure);
    }

    /**
     * <p>
     * The folder structure that defines the organizational structure for log files in S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #folderStructure}
     * will return {@link FolderStructure#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #folderStructureAsString}.
     * </p>
     * 
     * @return The folder structure that defines the organizational structure for log files in S3.
     * @see FolderStructure
     */
    public final String folderStructureAsString() {
        return folderStructure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(logFileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(folderStructureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogConfiguration)) {
            return false;
        }
        S3LogConfiguration other = (S3LogConfiguration) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(keyPrefix(), other.keyPrefix())
                && Objects.equals(bucketOwner(), other.bucketOwner())
                && Objects.equals(logFileFormatAsString(), other.logFileFormatAsString())
                && Objects.equals(folderStructureAsString(), other.folderStructureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3LogConfiguration").add("Bucket", bucket() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KeyPrefix", keyPrefix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BucketOwner", bucketOwner()).add("LogFileFormat", logFileFormatAsString())
                .add("FolderStructure", folderStructureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "keyPrefix":
            return Optional.ofNullable(clazz.cast(keyPrefix()));
        case "bucketOwner":
            return Optional.ofNullable(clazz.cast(bucketOwner()));
        case "logFileFormat":
            return Optional.ofNullable(clazz.cast(logFileFormatAsString()));
        case "folderStructure":
            return Optional.ofNullable(clazz.cast(folderStructureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucket", BUCKET_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        map.put("bucketOwner", BUCKET_OWNER_FIELD);
        map.put("logFileFormat", LOG_FILE_FORMAT_FIELD);
        map.put("folderStructure", FOLDER_STRUCTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3LogConfiguration, T> g) {
        return obj -> g.apply((S3LogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3LogConfiguration> {
        /**
         * <p>
         * The S3 bucket name where logs are delivered.
         * </p>
         * 
         * @param bucket
         *        The S3 bucket name where logs are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The S3 path prefix that determines where log files are stored.
         * </p>
         * 
         * @param keyPrefix
         *        The S3 path prefix that determines where log files are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefix(String keyPrefix);

        /**
         * <p>
         * The expected bucket owner of the target S3 bucket. The caller must have permissions to write to the target
         * bucket.
         * </p>
         * 
         * @param bucketOwner
         *        The expected bucket owner of the target S3 bucket. The caller must have permissions to write to the
         *        target bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwner(String bucketOwner);

        /**
         * <p>
         * The format of the LogFile that is written to S3.
         * </p>
         * 
         * @param logFileFormat
         *        The format of the LogFile that is written to S3.
         * @see LogFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFileFormat
         */
        Builder logFileFormat(String logFileFormat);

        /**
         * <p>
         * The format of the LogFile that is written to S3.
         * </p>
         * 
         * @param logFileFormat
         *        The format of the LogFile that is written to S3.
         * @see LogFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFileFormat
         */
        Builder logFileFormat(LogFileFormat logFileFormat);

        /**
         * <p>
         * The folder structure that defines the organizational structure for log files in S3.
         * </p>
         * 
         * @param folderStructure
         *        The folder structure that defines the organizational structure for log files in S3.
         * @see FolderStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderStructure
         */
        Builder folderStructure(String folderStructure);

        /**
         * <p>
         * The folder structure that defines the organizational structure for log files in S3.
         * </p>
         * 
         * @param folderStructure
         *        The folder structure that defines the organizational structure for log files in S3.
         * @see FolderStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderStructure
         */
        Builder folderStructure(FolderStructure folderStructure);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String keyPrefix;

        private String bucketOwner;

        private String logFileFormat;

        private String folderStructure;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogConfiguration model) {
            bucket(model.bucket);
            keyPrefix(model.keyPrefix);
            bucketOwner(model.bucketOwner);
            logFileFormat(model.logFileFormat);
            folderStructure(model.folderStructure);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPrefix() {
            return keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getBucketOwner() {
            return bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public final String getLogFileFormat() {
            return logFileFormat;
        }

        public final void setLogFileFormat(String logFileFormat) {
            this.logFileFormat = logFileFormat;
        }

        @Override
        public final Builder logFileFormat(String logFileFormat) {
            this.logFileFormat = logFileFormat;
            return this;
        }

        @Override
        public final Builder logFileFormat(LogFileFormat logFileFormat) {
            this.logFileFormat(logFileFormat == null ? null : logFileFormat.toString());
            return this;
        }

        public final String getFolderStructure() {
            return folderStructure;
        }

        public final void setFolderStructure(String folderStructure) {
            this.folderStructure = folderStructure;
        }

        @Override
        public final Builder folderStructure(String folderStructure) {
            this.folderStructure = folderStructure;
            return this;
        }

        @Override
        public final Builder folderStructure(FolderStructure folderStructure) {
            this.folderStructure(folderStructure == null ? null : folderStructure.toString());
            return this;
        }

        @Override
        public S3LogConfiguration build() {
            return new S3LogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
