/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the toolbar. This allows administrators to select the toolbar type and visual mode, set maximum
 * display resolution for sessions, and choose which items are visible to end users during their sessions. If
 * administrators do not modify these settings, end users retain control over their toolbar preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolbarConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolbarConfiguration.Builder, ToolbarConfiguration> {
    private static final SdkField<String> TOOLBAR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toolbarType").getter(getter(ToolbarConfiguration::toolbarTypeAsString))
            .setter(setter(Builder::toolbarType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolbarType").build()).build();

    private static final SdkField<String> VISUAL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visualMode").getter(getter(ToolbarConfiguration::visualModeAsString))
            .setter(setter(Builder::visualMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visualMode").build()).build();

    private static final SdkField<List<String>> HIDDEN_TOOLBAR_ITEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("hiddenToolbarItems")
            .getter(getter(ToolbarConfiguration::hiddenToolbarItemsAsStrings))
            .setter(setter(Builder::hiddenToolbarItemsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hiddenToolbarItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MAX_DISPLAY_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("maxDisplayResolution").getter(getter(ToolbarConfiguration::maxDisplayResolutionAsString))
            .setter(setter(Builder::maxDisplayResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDisplayResolution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLBAR_TYPE_FIELD,
            VISUAL_MODE_FIELD, HIDDEN_TOOLBAR_ITEMS_FIELD, MAX_DISPLAY_RESOLUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String toolbarType;

    private final String visualMode;

    private final List<String> hiddenToolbarItems;

    private final String maxDisplayResolution;

    private ToolbarConfiguration(BuilderImpl builder) {
        this.toolbarType = builder.toolbarType;
        this.visualMode = builder.visualMode;
        this.hiddenToolbarItems = builder.hiddenToolbarItems;
        this.maxDisplayResolution = builder.maxDisplayResolution;
    }

    /**
     * <p>
     * The type of toolbar displayed during the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolbarType} will
     * return {@link ToolbarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toolbarTypeAsString}.
     * </p>
     * 
     * @return The type of toolbar displayed during the session.
     * @see ToolbarType
     */
    public final ToolbarType toolbarType() {
        return ToolbarType.fromValue(toolbarType);
    }

    /**
     * <p>
     * The type of toolbar displayed during the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toolbarType} will
     * return {@link ToolbarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toolbarTypeAsString}.
     * </p>
     * 
     * @return The type of toolbar displayed during the session.
     * @see ToolbarType
     */
    public final String toolbarTypeAsString() {
        return toolbarType;
    }

    /**
     * <p>
     * The visual mode of the toolbar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visualMode} will
     * return {@link VisualMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visualModeAsString}.
     * </p>
     * 
     * @return The visual mode of the toolbar.
     * @see VisualMode
     */
    public final VisualMode visualMode() {
        return VisualMode.fromValue(visualMode);
    }

    /**
     * <p>
     * The visual mode of the toolbar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visualMode} will
     * return {@link VisualMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visualModeAsString}.
     * </p>
     * 
     * @return The visual mode of the toolbar.
     * @see VisualMode
     */
    public final String visualModeAsString() {
        return visualMode;
    }

    /**
     * <p>
     * The list of toolbar items to be hidden.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenToolbarItems} method.
     * </p>
     * 
     * @return The list of toolbar items to be hidden.
     */
    public final List<ToolbarItem> hiddenToolbarItems() {
        return HiddenToolbarItemListCopier.copyStringToEnum(hiddenToolbarItems);
    }

    /**
     * For responses, this returns true if the service returned a value for the HiddenToolbarItems property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHiddenToolbarItems() {
        return hiddenToolbarItems != null && !(hiddenToolbarItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of toolbar items to be hidden.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHiddenToolbarItems} method.
     * </p>
     * 
     * @return The list of toolbar items to be hidden.
     */
    public final List<String> hiddenToolbarItemsAsStrings() {
        return hiddenToolbarItems;
    }

    /**
     * <p>
     * The maximum display resolution that is allowed for the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maxDisplayResolution} will return {@link MaxDisplayResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #maxDisplayResolutionAsString}.
     * </p>
     * 
     * @return The maximum display resolution that is allowed for the session.
     * @see MaxDisplayResolution
     */
    public final MaxDisplayResolution maxDisplayResolution() {
        return MaxDisplayResolution.fromValue(maxDisplayResolution);
    }

    /**
     * <p>
     * The maximum display resolution that is allowed for the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #maxDisplayResolution} will return {@link MaxDisplayResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #maxDisplayResolutionAsString}.
     * </p>
     * 
     * @return The maximum display resolution that is allowed for the session.
     * @see MaxDisplayResolution
     */
    public final String maxDisplayResolutionAsString() {
        return maxDisplayResolution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toolbarTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visualModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasHiddenToolbarItems() ? hiddenToolbarItemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxDisplayResolutionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolbarConfiguration)) {
            return false;
        }
        ToolbarConfiguration other = (ToolbarConfiguration) obj;
        return Objects.equals(toolbarTypeAsString(), other.toolbarTypeAsString())
                && Objects.equals(visualModeAsString(), other.visualModeAsString())
                && hasHiddenToolbarItems() == other.hasHiddenToolbarItems()
                && Objects.equals(hiddenToolbarItemsAsStrings(), other.hiddenToolbarItemsAsStrings())
                && Objects.equals(maxDisplayResolutionAsString(), other.maxDisplayResolutionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolbarConfiguration").add("ToolbarType", toolbarTypeAsString())
                .add("VisualMode", visualModeAsString())
                .add("HiddenToolbarItems", hasHiddenToolbarItems() ? hiddenToolbarItemsAsStrings() : null)
                .add("MaxDisplayResolution", maxDisplayResolutionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toolbarType":
            return Optional.ofNullable(clazz.cast(toolbarTypeAsString()));
        case "visualMode":
            return Optional.ofNullable(clazz.cast(visualModeAsString()));
        case "hiddenToolbarItems":
            return Optional.ofNullable(clazz.cast(hiddenToolbarItemsAsStrings()));
        case "maxDisplayResolution":
            return Optional.ofNullable(clazz.cast(maxDisplayResolutionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("toolbarType", TOOLBAR_TYPE_FIELD);
        map.put("visualMode", VISUAL_MODE_FIELD);
        map.put("hiddenToolbarItems", HIDDEN_TOOLBAR_ITEMS_FIELD);
        map.put("maxDisplayResolution", MAX_DISPLAY_RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolbarConfiguration, T> g) {
        return obj -> g.apply((ToolbarConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolbarConfiguration> {
        /**
         * <p>
         * The type of toolbar displayed during the session.
         * </p>
         * 
         * @param toolbarType
         *        The type of toolbar displayed during the session.
         * @see ToolbarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolbarType
         */
        Builder toolbarType(String toolbarType);

        /**
         * <p>
         * The type of toolbar displayed during the session.
         * </p>
         * 
         * @param toolbarType
         *        The type of toolbar displayed during the session.
         * @see ToolbarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolbarType
         */
        Builder toolbarType(ToolbarType toolbarType);

        /**
         * <p>
         * The visual mode of the toolbar.
         * </p>
         * 
         * @param visualMode
         *        The visual mode of the toolbar.
         * @see VisualMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualMode
         */
        Builder visualMode(String visualMode);

        /**
         * <p>
         * The visual mode of the toolbar.
         * </p>
         * 
         * @param visualMode
         *        The visual mode of the toolbar.
         * @see VisualMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualMode
         */
        Builder visualMode(VisualMode visualMode);

        /**
         * <p>
         * The list of toolbar items to be hidden.
         * </p>
         * 
         * @param hiddenToolbarItems
         *        The list of toolbar items to be hidden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenToolbarItemsWithStrings(Collection<String> hiddenToolbarItems);

        /**
         * <p>
         * The list of toolbar items to be hidden.
         * </p>
         * 
         * @param hiddenToolbarItems
         *        The list of toolbar items to be hidden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenToolbarItemsWithStrings(String... hiddenToolbarItems);

        /**
         * <p>
         * The list of toolbar items to be hidden.
         * </p>
         * 
         * @param hiddenToolbarItems
         *        The list of toolbar items to be hidden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenToolbarItems(Collection<ToolbarItem> hiddenToolbarItems);

        /**
         * <p>
         * The list of toolbar items to be hidden.
         * </p>
         * 
         * @param hiddenToolbarItems
         *        The list of toolbar items to be hidden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenToolbarItems(ToolbarItem... hiddenToolbarItems);

        /**
         * <p>
         * The maximum display resolution that is allowed for the session.
         * </p>
         * 
         * @param maxDisplayResolution
         *        The maximum display resolution that is allowed for the session.
         * @see MaxDisplayResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaxDisplayResolution
         */
        Builder maxDisplayResolution(String maxDisplayResolution);

        /**
         * <p>
         * The maximum display resolution that is allowed for the session.
         * </p>
         * 
         * @param maxDisplayResolution
         *        The maximum display resolution that is allowed for the session.
         * @see MaxDisplayResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaxDisplayResolution
         */
        Builder maxDisplayResolution(MaxDisplayResolution maxDisplayResolution);
    }

    static final class BuilderImpl implements Builder {
        private String toolbarType;

        private String visualMode;

        private List<String> hiddenToolbarItems = DefaultSdkAutoConstructList.getInstance();

        private String maxDisplayResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolbarConfiguration model) {
            toolbarType(model.toolbarType);
            visualMode(model.visualMode);
            hiddenToolbarItemsWithStrings(model.hiddenToolbarItems);
            maxDisplayResolution(model.maxDisplayResolution);
        }

        public final String getToolbarType() {
            return toolbarType;
        }

        public final void setToolbarType(String toolbarType) {
            this.toolbarType = toolbarType;
        }

        @Override
        public final Builder toolbarType(String toolbarType) {
            this.toolbarType = toolbarType;
            return this;
        }

        @Override
        public final Builder toolbarType(ToolbarType toolbarType) {
            this.toolbarType(toolbarType == null ? null : toolbarType.toString());
            return this;
        }

        public final String getVisualMode() {
            return visualMode;
        }

        public final void setVisualMode(String visualMode) {
            this.visualMode = visualMode;
        }

        @Override
        public final Builder visualMode(String visualMode) {
            this.visualMode = visualMode;
            return this;
        }

        @Override
        public final Builder visualMode(VisualMode visualMode) {
            this.visualMode(visualMode == null ? null : visualMode.toString());
            return this;
        }

        public final Collection<String> getHiddenToolbarItems() {
            if (hiddenToolbarItems instanceof SdkAutoConstructList) {
                return null;
            }
            return hiddenToolbarItems;
        }

        public final void setHiddenToolbarItems(Collection<String> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copy(hiddenToolbarItems);
        }

        @Override
        public final Builder hiddenToolbarItemsWithStrings(Collection<String> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copy(hiddenToolbarItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenToolbarItemsWithStrings(String... hiddenToolbarItems) {
            hiddenToolbarItemsWithStrings(Arrays.asList(hiddenToolbarItems));
            return this;
        }

        @Override
        public final Builder hiddenToolbarItems(Collection<ToolbarItem> hiddenToolbarItems) {
            this.hiddenToolbarItems = HiddenToolbarItemListCopier.copyEnumToString(hiddenToolbarItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenToolbarItems(ToolbarItem... hiddenToolbarItems) {
            hiddenToolbarItems(Arrays.asList(hiddenToolbarItems));
            return this;
        }

        public final String getMaxDisplayResolution() {
            return maxDisplayResolution;
        }

        public final void setMaxDisplayResolution(String maxDisplayResolution) {
            this.maxDisplayResolution = maxDisplayResolution;
        }

        @Override
        public final Builder maxDisplayResolution(String maxDisplayResolution) {
            this.maxDisplayResolution = maxDisplayResolution;
            return this;
        }

        @Override
        public final Builder maxDisplayResolution(MaxDisplayResolution maxDisplayResolution) {
            this.maxDisplayResolution(maxDisplayResolution == null ? null : maxDisplayResolution.toString());
            return this;
        }

        @Override
        public ToolbarConfiguration build() {
            return new ToolbarConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
