/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionLoggerRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateSessionLoggerRequest.Builder, UpdateSessionLoggerRequest> {
    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionLoggerArn").getter(getter(UpdateSessionLoggerRequest::sessionLoggerArn))
            .setter(setter(Builder::sessionLoggerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("sessionLoggerArn").build())
            .build();

    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.<EventFilter> builder(MarshallingType.SDK_POJO)
            .memberName("eventFilter").getter(getter(UpdateSessionLoggerRequest::eventFilter))
            .setter(setter(Builder::eventFilter)).constructor(EventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFilter").build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(UpdateSessionLoggerRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateSessionLoggerRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_ARN_FIELD,
            EVENT_FILTER_FIELD, LOG_CONFIGURATION_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionLoggerArn;

    private final EventFilter eventFilter;

    private final LogConfiguration logConfiguration;

    private final String displayName;

    private UpdateSessionLoggerRequest(BuilderImpl builder) {
        super(builder);
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.eventFilter = builder.eventFilter;
        this.logConfiguration = builder.logConfiguration;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The ARN of the session logger to update.
     * </p>
     * 
     * @return The ARN of the session logger to update.
     */
    public final String sessionLoggerArn() {
        return sessionLoggerArn;
    }

    /**
     * <p>
     * The updated eventFilter.
     * </p>
     * 
     * @return The updated eventFilter.
     */
    public final EventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * <p>
     * The updated logConfiguration.
     * </p>
     * 
     * @return The updated logConfiguration.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The updated display name.
     * </p>
     * 
     * @return The updated display name.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionLoggerRequest)) {
            return false;
        }
        UpdateSessionLoggerRequest other = (UpdateSessionLoggerRequest) obj;
        return Objects.equals(sessionLoggerArn(), other.sessionLoggerArn()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionLoggerRequest").add("SessionLoggerArn", sessionLoggerArn())
                .add("EventFilter", eventFilter()).add("LogConfiguration", logConfiguration())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionLoggerArn":
            return Optional.ofNullable(clazz.cast(sessionLoggerArn()));
        case "eventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("eventFilter", EVENT_FILTER_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionLoggerRequest, T> g) {
        return obj -> g.apply((UpdateSessionLoggerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSessionLoggerRequest> {
        /**
         * <p>
         * The ARN of the session logger to update.
         * </p>
         * 
         * @param sessionLoggerArn
         *        The ARN of the session logger to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggerArn(String sessionLoggerArn);

        /**
         * <p>
         * The updated eventFilter.
         * </p>
         * 
         * @param eventFilter
         *        The updated eventFilter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilter eventFilter);

        /**
         * <p>
         * The updated eventFilter.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventFilter.Builder} avoiding the need to
         * create one manually via {@link EventFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #eventFilter(EventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link EventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(EventFilter)
         */
        default Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return eventFilter(EventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * <p>
         * The updated logConfiguration.
         * </p>
         * 
         * @param logConfiguration
         *        The updated logConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The updated logConfiguration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The updated display name.
         * </p>
         * 
         * @param displayName
         *        The updated display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String sessionLoggerArn;

        private EventFilter eventFilter;

        private LogConfiguration logConfiguration;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionLoggerRequest model) {
            super(model);
            sessionLoggerArn(model.sessionLoggerArn);
            eventFilter(model.eventFilter);
            logConfiguration(model.logConfiguration);
            displayName(model.displayName);
        }

        public final String getSessionLoggerArn() {
            return sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final EventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionLoggerRequest build() {
            return new UpdateSessionLoggerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
