/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionLoggerResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<UpdateSessionLoggerResponse.Builder, UpdateSessionLoggerResponse> {
    private static final SdkField<SessionLogger> SESSION_LOGGER_FIELD = SdkField
            .<SessionLogger> builder(MarshallingType.SDK_POJO).memberName("sessionLogger")
            .getter(getter(UpdateSessionLoggerResponse::sessionLogger)).setter(setter(Builder::sessionLogger))
            .constructor(SessionLogger::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLogger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SessionLogger sessionLogger;

    private UpdateSessionLoggerResponse(BuilderImpl builder) {
        super(builder);
        this.sessionLogger = builder.sessionLogger;
    }

    /**
     * <p>
     * The updated details of the session logger.
     * </p>
     * 
     * @return The updated details of the session logger.
     */
    public final SessionLogger sessionLogger() {
        return sessionLogger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionLogger());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionLoggerResponse)) {
            return false;
        }
        UpdateSessionLoggerResponse other = (UpdateSessionLoggerResponse) obj;
        return Objects.equals(sessionLogger(), other.sessionLogger());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionLoggerResponse").add("SessionLogger", sessionLogger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionLogger":
            return Optional.ofNullable(clazz.cast(sessionLogger()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionLogger", SESSION_LOGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionLoggerResponse, T> g) {
        return obj -> g.apply((UpdateSessionLoggerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSessionLoggerResponse> {
        /**
         * <p>
         * The updated details of the session logger.
         * </p>
         * 
         * @param sessionLogger
         *        The updated details of the session logger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLogger(SessionLogger sessionLogger);

        /**
         * <p>
         * The updated details of the session logger.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionLogger.Builder} avoiding the need
         * to create one manually via {@link SessionLogger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionLogger.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionLogger(SessionLogger)}.
         * 
         * @param sessionLogger
         *        a consumer that will call methods on {@link SessionLogger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionLogger(SessionLogger)
         */
        default Builder sessionLogger(Consumer<SessionLogger.Builder> sessionLogger) {
            return sessionLogger(SessionLogger.builder().applyMutation(sessionLogger).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private SessionLogger sessionLogger;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionLoggerResponse model) {
            super(model);
            sessionLogger(model.sessionLogger);
        }

        public final SessionLogger.Builder getSessionLogger() {
            return sessionLogger != null ? sessionLogger.toBuilder() : null;
        }

        public final void setSessionLogger(SessionLogger.BuilderImpl sessionLogger) {
            this.sessionLogger = sessionLogger != null ? sessionLogger.build() : null;
        }

        @Override
        public final Builder sessionLogger(SessionLogger sessionLogger) {
            this.sessionLogger = sessionLogger;
            return this;
        }

        @Override
        public UpdateSessionLoggerResponse build() {
            return new UpdateSessionLoggerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
