/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustStoreRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateTrustStoreRequest.Builder, UpdateTrustStoreRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustStoreArn").getter(getter(UpdateTrustStoreRequest::trustStoreArn))
            .setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("trustStoreArn").build()).build();

    private static final SdkField<List<SdkBytes>> CERTIFICATES_TO_ADD_FIELD = SdkField
            .<List<SdkBytes>> builder(MarshallingType.LIST)
            .memberName("certificatesToAdd")
            .getter(getter(UpdateTrustStoreRequest::certificatesToAdd))
            .setter(setter(Builder::certificatesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CERTIFICATES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("certificatesToDelete")
            .getter(getter(UpdateTrustStoreRequest::certificatesToDelete))
            .setter(setter(Builder::certificatesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateTrustStoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD,
            CERTIFICATES_TO_ADD_FIELD, CERTIFICATES_TO_DELETE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustStoreArn;

    private final List<SdkBytes> certificatesToAdd;

    private final List<String> certificatesToDelete;

    private final String clientToken;

    private UpdateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.certificatesToAdd = builder.certificatesToAdd;
        this.certificatesToDelete = builder.certificatesToDelete;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ARN of the trust store.
     * </p>
     * 
     * @return The ARN of the trust store.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificatesToAdd property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificatesToAdd() {
        return certificatesToAdd != null && !(certificatesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CA certificates to add to the trust store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificatesToAdd} method.
     * </p>
     * 
     * @return A list of CA certificates to add to the trust store.
     */
    public final List<SdkBytes> certificatesToAdd() {
        return certificatesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificatesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificatesToDelete() {
        return certificatesToDelete != null && !(certificatesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of CA certificates to delete from a trust store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificatesToDelete} method.
     * </p>
     * 
     * @return A list of CA certificates to delete from a trust store.
     */
    public final List<String> certificatesToDelete() {
        return certificatesToDelete;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificatesToAdd() ? certificatesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificatesToDelete() ? certificatesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustStoreRequest)) {
            return false;
        }
        UpdateTrustStoreRequest other = (UpdateTrustStoreRequest) obj;
        return Objects.equals(trustStoreArn(), other.trustStoreArn()) && hasCertificatesToAdd() == other.hasCertificatesToAdd()
                && Objects.equals(certificatesToAdd(), other.certificatesToAdd())
                && hasCertificatesToDelete() == other.hasCertificatesToDelete()
                && Objects.equals(certificatesToDelete(), other.certificatesToDelete())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustStoreRequest").add("TrustStoreArn", trustStoreArn())
                .add("CertificatesToAdd", hasCertificatesToAdd() ? certificatesToAdd() : null)
                .add("CertificatesToDelete", hasCertificatesToDelete() ? certificatesToDelete() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "certificatesToAdd":
            return Optional.ofNullable(clazz.cast(certificatesToAdd()));
        case "certificatesToDelete":
            return Optional.ofNullable(clazz.cast(certificatesToDelete()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("certificatesToAdd", CERTIFICATES_TO_ADD_FIELD);
        map.put("certificatesToDelete", CERTIFICATES_TO_DELETE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustStoreRequest, T> g) {
        return obj -> g.apply((UpdateTrustStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustStoreRequest> {
        /**
         * <p>
         * The ARN of the trust store.
         * </p>
         * 
         * @param trustStoreArn
         *        The ARN of the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * A list of CA certificates to add to the trust store.
         * </p>
         * 
         * @param certificatesToAdd
         *        A list of CA certificates to add to the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesToAdd(Collection<SdkBytes> certificatesToAdd);

        /**
         * <p>
         * A list of CA certificates to add to the trust store.
         * </p>
         * 
         * @param certificatesToAdd
         *        A list of CA certificates to add to the trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesToAdd(SdkBytes... certificatesToAdd);

        /**
         * <p>
         * A list of CA certificates to delete from a trust store.
         * </p>
         * 
         * @param certificatesToDelete
         *        A list of CA certificates to delete from a trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesToDelete(Collection<String> certificatesToDelete);

        /**
         * <p>
         * A list of CA certificates to delete from a trust store.
         * </p>
         * 
         * @param certificatesToDelete
         *        A list of CA certificates to delete from a trust store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatesToDelete(String... certificatesToDelete);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String trustStoreArn;

        private List<SdkBytes> certificatesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> certificatesToDelete = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustStoreRequest model) {
            super(model);
            trustStoreArn(model.trustStoreArn);
            certificatesToAdd(model.certificatesToAdd);
            certificatesToDelete(model.certificatesToDelete);
            clientToken(model.clientToken);
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final List<ByteBuffer> getCertificatesToAdd() {
            if (certificatesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return certificatesToAdd == null ? null : certificatesToAdd.stream().map(SdkBytes::asByteBuffer)
                    .collect(Collectors.toList());
        }

        public final void setCertificatesToAdd(Collection<ByteBuffer> certificatesToAdd) {
            certificatesToAdd(certificatesToAdd == null ? null : certificatesToAdd.stream().map(SdkBytes::fromByteBuffer)
                    .collect(Collectors.toList()));
        }

        @Override
        public final Builder certificatesToAdd(Collection<SdkBytes> certificatesToAdd) {
            this.certificatesToAdd = CertificateListCopier.copy(certificatesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesToAdd(SdkBytes... certificatesToAdd) {
            certificatesToAdd(Arrays.asList(certificatesToAdd));
            return this;
        }

        public final Collection<String> getCertificatesToDelete() {
            if (certificatesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return certificatesToDelete;
        }

        public final void setCertificatesToDelete(Collection<String> certificatesToDelete) {
            this.certificatesToDelete = CertificateThumbprintListCopier.copy(certificatesToDelete);
        }

        @Override
        public final Builder certificatesToDelete(Collection<String> certificatesToDelete) {
            this.certificatesToDelete = CertificateThumbprintListCopier.copy(certificatesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatesToDelete(String... certificatesToDelete) {
            certificatesToDelete(Arrays.asList(certificatesToDelete));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustStoreRequest build() {
            return new UpdateTrustStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
