/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy that specifies which URLs end users are allowed to access or which URLs or domain categories they are
 * restricted from accessing for enhanced security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebContentFilteringPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<WebContentFilteringPolicy.Builder, WebContentFilteringPolicy> {
    private static final SdkField<List<String>> BLOCKED_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedCategories")
            .getter(getter(WebContentFilteringPolicy::blockedCategoriesAsStrings))
            .setter(setter(Builder::blockedCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedUrls")
            .getter(getter(WebContentFilteringPolicy::allowedUrls))
            .setter(setter(Builder::allowedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("blockedUrls")
            .getter(getter(WebContentFilteringPolicy::blockedUrls))
            .setter(setter(Builder::blockedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_CATEGORIES_FIELD,
            ALLOWED_URLS_FIELD, BLOCKED_URLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> blockedCategories;

    private final List<String> allowedUrls;

    private final List<String> blockedUrls;

    private WebContentFilteringPolicy(BuilderImpl builder) {
        this.blockedCategories = builder.blockedCategories;
        this.allowedUrls = builder.allowedUrls;
        this.blockedUrls = builder.blockedUrls;
    }

    /**
     * <p>
     * Categories of websites that are blocked on the end user’s browsers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedCategories} method.
     * </p>
     * 
     * @return Categories of websites that are blocked on the end user’s browsers.
     */
    public final List<Category> blockedCategories() {
        return BlockedCategoriesCopier.copyStringToEnum(blockedCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedCategories() {
        return blockedCategories != null && !(blockedCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Categories of websites that are blocked on the end user’s browsers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedCategories} method.
     * </p>
     * 
     * @return Categories of websites that are blocked on the end user’s browsers.
     */
    public final List<String> blockedCategoriesAsStrings() {
        return blockedCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedUrls() {
        return allowedUrls != null && !(allowedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * URLs and domains that are always accessible to end users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedUrls} method.
     * </p>
     * 
     * @return URLs and domains that are always accessible to end users.
     */
    public final List<String> allowedUrls() {
        return allowedUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockedUrls() {
        return blockedUrls != null && !(blockedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * URLs and domains that end users cannot access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedUrls} method.
     * </p>
     * 
     * @return URLs and domains that end users cannot access.
     */
    public final List<String> blockedUrls() {
        return blockedUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedCategories() ? blockedCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedUrls() ? allowedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedUrls() ? blockedUrls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebContentFilteringPolicy)) {
            return false;
        }
        WebContentFilteringPolicy other = (WebContentFilteringPolicy) obj;
        return hasBlockedCategories() == other.hasBlockedCategories()
                && Objects.equals(blockedCategoriesAsStrings(), other.blockedCategoriesAsStrings())
                && hasAllowedUrls() == other.hasAllowedUrls() && Objects.equals(allowedUrls(), other.allowedUrls())
                && hasBlockedUrls() == other.hasBlockedUrls() && Objects.equals(blockedUrls(), other.blockedUrls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebContentFilteringPolicy")
                .add("BlockedCategories", hasBlockedCategories() ? blockedCategoriesAsStrings() : null)
                .add("AllowedUrls", allowedUrls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedUrls", blockedUrls() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blockedCategories":
            return Optional.ofNullable(clazz.cast(blockedCategoriesAsStrings()));
        case "allowedUrls":
            return Optional.ofNullable(clazz.cast(allowedUrls()));
        case "blockedUrls":
            return Optional.ofNullable(clazz.cast(blockedUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blockedCategories", BLOCKED_CATEGORIES_FIELD);
        map.put("allowedUrls", ALLOWED_URLS_FIELD);
        map.put("blockedUrls", BLOCKED_URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebContentFilteringPolicy, T> g) {
        return obj -> g.apply((WebContentFilteringPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebContentFilteringPolicy> {
        /**
         * <p>
         * Categories of websites that are blocked on the end user’s browsers.
         * </p>
         * 
         * @param blockedCategories
         *        Categories of websites that are blocked on the end user’s browsers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedCategoriesWithStrings(Collection<String> blockedCategories);

        /**
         * <p>
         * Categories of websites that are blocked on the end user’s browsers.
         * </p>
         * 
         * @param blockedCategories
         *        Categories of websites that are blocked on the end user’s browsers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedCategoriesWithStrings(String... blockedCategories);

        /**
         * <p>
         * Categories of websites that are blocked on the end user’s browsers.
         * </p>
         * 
         * @param blockedCategories
         *        Categories of websites that are blocked on the end user’s browsers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedCategories(Collection<Category> blockedCategories);

        /**
         * <p>
         * Categories of websites that are blocked on the end user’s browsers.
         * </p>
         * 
         * @param blockedCategories
         *        Categories of websites that are blocked on the end user’s browsers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedCategories(Category... blockedCategories);

        /**
         * <p>
         * URLs and domains that are always accessible to end users.
         * </p>
         * 
         * @param allowedUrls
         *        URLs and domains that are always accessible to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUrls(Collection<String> allowedUrls);

        /**
         * <p>
         * URLs and domains that are always accessible to end users.
         * </p>
         * 
         * @param allowedUrls
         *        URLs and domains that are always accessible to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedUrls(String... allowedUrls);

        /**
         * <p>
         * URLs and domains that end users cannot access.
         * </p>
         * 
         * @param blockedUrls
         *        URLs and domains that end users cannot access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedUrls(Collection<String> blockedUrls);

        /**
         * <p>
         * URLs and domains that end users cannot access.
         * </p>
         * 
         * @param blockedUrls
         *        URLs and domains that end users cannot access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedUrls(String... blockedUrls);
    }

    static final class BuilderImpl implements Builder {
        private List<String> blockedCategories = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WebContentFilteringPolicy model) {
            blockedCategoriesWithStrings(model.blockedCategories);
            allowedUrls(model.allowedUrls);
            blockedUrls(model.blockedUrls);
        }

        public final Collection<String> getBlockedCategories() {
            if (blockedCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedCategories;
        }

        public final void setBlockedCategories(Collection<String> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copy(blockedCategories);
        }

        @Override
        public final Builder blockedCategoriesWithStrings(Collection<String> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copy(blockedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedCategoriesWithStrings(String... blockedCategories) {
            blockedCategoriesWithStrings(Arrays.asList(blockedCategories));
            return this;
        }

        @Override
        public final Builder blockedCategories(Collection<Category> blockedCategories) {
            this.blockedCategories = BlockedCategoriesCopier.copyEnumToString(blockedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedCategories(Category... blockedCategories) {
            blockedCategories(Arrays.asList(blockedCategories));
            return this;
        }

        public final Collection<String> getAllowedUrls() {
            if (allowedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedUrls;
        }

        public final void setAllowedUrls(Collection<String> allowedUrls) {
            this.allowedUrls = UrlPatternListCopier.copy(allowedUrls);
        }

        @Override
        public final Builder allowedUrls(Collection<String> allowedUrls) {
            this.allowedUrls = UrlPatternListCopier.copy(allowedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedUrls(String... allowedUrls) {
            allowedUrls(Arrays.asList(allowedUrls));
            return this;
        }

        public final Collection<String> getBlockedUrls() {
            if (blockedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedUrls;
        }

        public final void setBlockedUrls(Collection<String> blockedUrls) {
            this.blockedUrls = UrlPatternListCopier.copy(blockedUrls);
        }

        @Override
        public final Builder blockedUrls(Collection<String> blockedUrls) {
            this.blockedUrls = UrlPatternListCopier.copy(blockedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedUrls(String... blockedUrls) {
            blockedUrls(Arrays.asList(blockedUrls));
            return this;
        }

        @Override
        public WebContentFilteringPolicy build() {
            return new WebContentFilteringPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
