/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateNetworkSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<AssociateNetworkSettingsRequest.Builder, AssociateNetworkSettingsRequest> {
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(AssociateNetworkSettingsRequest::portalArn))
            .setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("portalArn").build()).build();

    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(AssociateNetworkSettingsRequest::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("networkSettingsArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ARN_FIELD,
            NETWORK_SETTINGS_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String portalArn;

    private final String networkSettingsArn;

    private AssociateNetworkSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.portalArn = builder.portalArn;
        this.networkSettingsArn = builder.networkSettingsArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The ARN of the network settings.
     * </p>
     * 
     * @return The ARN of the network settings.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateNetworkSettingsRequest)) {
            return false;
        }
        AssociateNetworkSettingsRequest other = (AssociateNetworkSettingsRequest) obj;
        return Objects.equals(portalArn(), other.portalArn()) && Objects.equals(networkSettingsArn(), other.networkSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateNetworkSettingsRequest").add("PortalArn", portalArn())
                .add("NetworkSettingsArn", networkSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portalArn", PORTAL_ARN_FIELD);
        map.put("networkSettingsArn", NETWORK_SETTINGS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateNetworkSettingsRequest, T> g) {
        return obj -> g.apply((AssociateNetworkSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateNetworkSettingsRequest> {
        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The ARN of the network settings.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String portalArn;

        private String networkSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateNetworkSettingsRequest model) {
            super(model);
            portalArn(model.portalArn);
            networkSettingsArn(model.networkSettingsArn);
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateNetworkSettingsRequest build() {
            return new AssociateNetworkSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
