/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pattern configuration for redacting custom data types in session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPattern implements SdkPojo, Serializable, ToCopyableBuilder<CustomPattern.Builder, CustomPattern> {
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternName").getter(getter(CustomPattern::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternName").build()).build();

    private static final SdkField<String> PATTERN_REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternRegex").getter(getter(CustomPattern::patternRegex)).setter(setter(Builder::patternRegex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternRegex").build()).build();

    private static final SdkField<String> PATTERN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternDescription").getter(getter(CustomPattern::patternDescription))
            .setter(setter(Builder::patternDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternDescription").build())
            .build();

    private static final SdkField<String> KEYWORD_REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keywordRegex").getter(getter(CustomPattern::keywordRegex)).setter(setter(Builder::keywordRegex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywordRegex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_NAME_FIELD,
            PATTERN_REGEX_FIELD, PATTERN_DESCRIPTION_FIELD, KEYWORD_REGEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String patternName;

    private final String patternRegex;

    private final String patternDescription;

    private final String keywordRegex;

    private CustomPattern(BuilderImpl builder) {
        this.patternName = builder.patternName;
        this.patternRegex = builder.patternRegex;
        this.patternDescription = builder.patternDescription;
        this.keywordRegex = builder.keywordRegex;
    }

    /**
     * <p>
     * The pattern name for the custom pattern.
     * </p>
     * 
     * @return The pattern name for the custom pattern.
     */
    public final String patternName() {
        return patternName;
    }

    /**
     * <p>
     * The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be
     * enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
     * </p>
     * 
     * @return The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern
     *         must be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
     */
    public final String patternRegex() {
        return patternRegex;
    }

    /**
     * <p>
     * The pattern description for the customer pattern.
     * </p>
     * 
     * @return The pattern description for the customer pattern.
     */
    public final String patternDescription() {
        return patternDescription;
    }

    /**
     * <p>
     * The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is
     * used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no
     * keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow
     * JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second
     * slash. For example, “/ab+c/gi”
     * </p>
     * 
     * @return The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword
     *         regex is used to search within the proximity of the match. If there is a keyword match, then the match is
     *         confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The
     *         format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have
     *         flags behind the second slash. For example, “/ab+c/gi”
     */
    public final String keywordRegex() {
        return keywordRegex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(patternRegex());
        hashCode = 31 * hashCode + Objects.hashCode(patternDescription());
        hashCode = 31 * hashCode + Objects.hashCode(keywordRegex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPattern)) {
            return false;
        }
        CustomPattern other = (CustomPattern) obj;
        return Objects.equals(patternName(), other.patternName()) && Objects.equals(patternRegex(), other.patternRegex())
                && Objects.equals(patternDescription(), other.patternDescription())
                && Objects.equals(keywordRegex(), other.keywordRegex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPattern")
                .add("PatternName", patternName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PatternRegex", patternRegex() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PatternDescription", patternDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KeywordRegex", keywordRegex() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "patternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "patternRegex":
            return Optional.ofNullable(clazz.cast(patternRegex()));
        case "patternDescription":
            return Optional.ofNullable(clazz.cast(patternDescription()));
        case "keywordRegex":
            return Optional.ofNullable(clazz.cast(keywordRegex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("patternName", PATTERN_NAME_FIELD);
        map.put("patternRegex", PATTERN_REGEX_FIELD);
        map.put("patternDescription", PATTERN_DESCRIPTION_FIELD);
        map.put("keywordRegex", KEYWORD_REGEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomPattern, T> g) {
        return obj -> g.apply((CustomPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPattern> {
        /**
         * <p>
         * The pattern name for the custom pattern.
         * </p>
         * 
         * @param patternName
         *        The pattern name for the custom pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must
         * be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
         * </p>
         * 
         * @param patternRegex
         *        The pattern regex for the customer pattern. The format must follow JavaScript regex format. The
         *        pattern must be enclosed between slashes, and can have flags behind the second slash. For example:
         *        “/ab+c/gi”.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternRegex(String patternRegex);

        /**
         * <p>
         * The pattern description for the customer pattern.
         * </p>
         * 
         * @param patternDescription
         *        The pattern description for the customer pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternDescription(String patternDescription);

        /**
         * <p>
         * The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is
         * used to search within the proximity of the match. If there is a keyword match, then the match is confirmed.
         * If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must
         * follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the
         * second slash. For example, “/ab+c/gi”
         * </p>
         * 
         * @param keywordRegex
         *        The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword
         *        regex is used to search within the proximity of the match. If there is a keyword match, then the match
         *        is confirmed. If no keyword regex is provided, the pattern regex match will automatically be
         *        confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between
         *        slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywordRegex(String keywordRegex);
    }

    static final class BuilderImpl implements Builder {
        private String patternName;

        private String patternRegex;

        private String patternDescription;

        private String keywordRegex;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPattern model) {
            patternName(model.patternName);
            patternRegex(model.patternRegex);
            patternDescription(model.patternDescription);
            keywordRegex(model.keywordRegex);
        }

        public final String getPatternName() {
            return patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getPatternRegex() {
            return patternRegex;
        }

        public final void setPatternRegex(String patternRegex) {
            this.patternRegex = patternRegex;
        }

        @Override
        public final Builder patternRegex(String patternRegex) {
            this.patternRegex = patternRegex;
            return this;
        }

        public final String getPatternDescription() {
            return patternDescription;
        }

        public final void setPatternDescription(String patternDescription) {
            this.patternDescription = patternDescription;
        }

        @Override
        public final Builder patternDescription(String patternDescription) {
            this.patternDescription = patternDescription;
            return this;
        }

        public final String getKeywordRegex() {
            return keywordRegex;
        }

        public final void setKeywordRegex(String keywordRegex) {
            this.keywordRegex = keywordRegex;
        }

        @Override
        public final Builder keywordRegex(String keywordRegex) {
            this.keywordRegex = keywordRegex;
            return this;
        }

        @Override
        public CustomPattern build() {
            return new CustomPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
