/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Event {
    WEBSITE_INTERACT("WebsiteInteract"),

    FILE_DOWNLOAD_FROM_SECURE_BROWSER_TO_REMOTE_DISK("FileDownloadFromSecureBrowserToRemoteDisk"),

    FILE_TRANSFER_FROM_REMOTE_TO_LOCAL_DISK("FileTransferFromRemoteToLocalDisk"),

    FILE_TRANSFER_FROM_LOCAL_TO_REMOTE_DISK("FileTransferFromLocalToRemoteDisk"),

    FILE_UPLOAD_FROM_REMOTE_DISK_TO_SECURE_BROWSER("FileUploadFromRemoteDiskToSecureBrowser"),

    CONTENT_PASTE_TO_WEBSITE("ContentPasteToWebsite"),

    CONTENT_TRANSFER_FROM_LOCAL_TO_REMOTE_CLIPBOARD("ContentTransferFromLocalToRemoteClipboard"),

    CONTENT_COPY_FROM_WEBSITE("ContentCopyFromWebsite"),

    URL_LOAD("UrlLoad"),

    TAB_OPEN("TabOpen"),

    TAB_CLOSE("TabClose"),

    PRINT_JOB_SUBMIT("PrintJobSubmit"),

    SESSION_CONNECT("SessionConnect"),

    SESSION_START("SessionStart"),

    SESSION_DISCONNECT("SessionDisconnect"),

    SESSION_END("SessionEnd"),

    URL_BLOCK_BY_CONTENT_FILTER("UrlBlockByContentFilter"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Event> VALUE_MAP = EnumUtils.uniqueIndex(Event.class, Event::toString);

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Event corresponding to the value
     */
    public static Event fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Event}s
     */
    public static Set<Event> knownValues() {
        Set<Event> knownValues = EnumSet.allOf(Event.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
