/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter that specifies the events to monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventFilter.Builder, EventFilter> {
    private static final SdkField<Unit> ALL_FIELD = SdkField.<Unit> builder(MarshallingType.SDK_POJO).memberName("all")
            .getter(getter(EventFilter::all)).setter(setter(Builder::all)).constructor(Unit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("all").build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(EventFilter::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, INCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Unit all;

    private final List<String> include;

    private final Type type;

    private EventFilter(BuilderImpl builder) {
        this.all = builder.all;
        this.include = builder.include;
        this.type = builder.type;
    }

    /**
     * <p>
     * The filter that monitors all of the available events, including any new events emitted in the future.
     * </p>
     * 
     * @return The filter that monitors all of the available events, including any new events emitted in the future.
     */
    public final Unit all() {
        return all;
    }

    /**
     * <p>
     * The filter that monitors only the listed set of events. New events are not auto-monitored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return The filter that monitors only the listed set of events. New events are not auto-monitored.
     */
    public final List<Event> include() {
        return EventsCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter that monitors only the listed set of events. New events are not auto-monitored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return The filter that monitors only the listed set of events. New events are not auto-monitored.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(all());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter) obj;
        return Objects.equals(all(), other.all()) && hasInclude() == other.hasInclude()
                && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventFilter").add("All", all()).add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "all":
            return Optional.ofNullable(clazz.cast(all()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #all()} initialized to the given value.
     *
     * <p>
     * The filter that monitors all of the available events, including any new events emitted in the future.
     * </p>
     * 
     * @param all
     *        The filter that monitors all of the available events, including any new events emitted in the future.
     */
    public static EventFilter fromAll(Unit all) {
        return builder().all(all).build();
    }

    /**
     * Create an instance of this class with {@link #all()} initialized to the given value.
     *
     * <p>
     * The filter that monitors all of the available events, including any new events emitted in the future.
     * </p>
     * 
     * @param all
     *        The filter that monitors all of the available events, including any new events emitted in the future.
     */
    public static EventFilter fromAll(Consumer<Unit.Builder> all) {
        Unit.Builder builder = Unit.builder();
        all.accept(builder);
        return fromAll(builder.build());
    }

    /**
     * Create an instance of this class with {@link #includeAsStrings()} initialized to the given value.
     *
     * <p>
     * The filter that monitors only the listed set of events. New events are not auto-monitored.
     * </p>
     * 
     * @param include
     *        The filter that monitors only the listed set of events. New events are not auto-monitored.
     */
    public static EventFilter fromIncludeWithStrings(List<String> includeWithStrings) {
        return builder().includeWithStrings(includeWithStrings).build();
    }

    /**
     * Create an instance of this class with {@link #includeAsStrings()} initialized to the given value.
     *
     * <p>
     * The filter that monitors only the listed set of events. New events are not auto-monitored.
     * </p>
     * 
     * @param include
     *        The filter that monitors only the listed set of events. New events are not auto-monitored.
     */
    public static EventFilter fromInclude(List<Event> includeWithStrings) {
        return builder().include(includeWithStrings).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("all", ALL_FIELD);
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFilter> {
        /**
         * <p>
         * The filter that monitors all of the available events, including any new events emitted in the future.
         * </p>
         * 
         * @param all
         *        The filter that monitors all of the available events, including any new events emitted in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder all(Unit all);

        /**
         * <p>
         * The filter that monitors all of the available events, including any new events emitted in the future.
         * </p>
         * This is a convenience method that creates an instance of the {@link Unit.Builder} avoiding the need to create
         * one manually via {@link Unit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Unit.Builder#build()} is called immediately and its result is
         * passed to {@link #all(Unit)}.
         * 
         * @param all
         *        a consumer that will call methods on {@link Unit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #all(Unit)
         */
        default Builder all(Consumer<Unit.Builder> all) {
            return all(Unit.builder().applyMutation(all).build());
        }

        /**
         * <p>
         * The filter that monitors only the listed set of events. New events are not auto-monitored.
         * </p>
         * 
         * @param include
         *        The filter that monitors only the listed set of events. New events are not auto-monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * The filter that monitors only the listed set of events. New events are not auto-monitored.
         * </p>
         * 
         * @param include
         *        The filter that monitors only the listed set of events. New events are not auto-monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * The filter that monitors only the listed set of events. New events are not auto-monitored.
         * </p>
         * 
         * @param include
         *        The filter that monitors only the listed set of events. New events are not auto-monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<Event> include);

        /**
         * <p>
         * The filter that monitors only the listed set of events. New events are not auto-monitored.
         * </p>
         * 
         * @param include
         *        The filter that monitors only the listed set of events. New events are not auto-monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Event... include);
    }

    static final class BuilderImpl implements Builder {
        private Unit all;

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            all(model.all);
            includeWithStrings(model.include);
        }

        public final Unit.Builder getAll() {
            return all != null ? all.toBuilder() : null;
        }

        public final void setAll(Unit.BuilderImpl all) {
            Object oldValue = this.all;
            this.all = all != null ? all.build() : null;
            handleUnionValueChange(Type.ALL, oldValue, this.all);
        }

        @Override
        public final Builder all(Unit all) {
            Object oldValue = this.all;
            this.all = all;
            handleUnionValueChange(Type.ALL, oldValue, this.all);
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            Object oldValue = this.include;
            this.include = EventsCopier.copy(include);
            handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            Object oldValue = this.include;
            this.include = EventsCopier.copy(include);
            handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<Event> include) {
            Object oldValue = this.include;
            this.include = EventsCopier.copyEnumToString(include);
            handleUnionValueChange(Type.INCLUDE, oldValue, this.include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(Event... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EventFilter#type()
     */
    public enum Type {
        ALL,

        INCLUDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
