/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPortalResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<GetPortalResponse.Builder, GetPortalResponse> {
    private static final SdkField<Portal> PORTAL_FIELD = SdkField.<Portal> builder(MarshallingType.SDK_POJO).memberName("portal")
            .getter(getter(GetPortalResponse::portal)).setter(setter(Builder::portal)).constructor(Portal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Portal portal;

    private GetPortalResponse(BuilderImpl builder) {
        super(builder);
        this.portal = builder.portal;
    }

    /**
     * <p>
     * The web portal.
     * </p>
     * 
     * @return The web portal.
     */
    public final Portal portal() {
        return portal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPortalResponse)) {
            return false;
        }
        GetPortalResponse other = (GetPortalResponse) obj;
        return Objects.equals(portal(), other.portal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPortalResponse").add("Portal", portal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portal":
            return Optional.ofNullable(clazz.cast(portal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portal", PORTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPortalResponse, T> g) {
        return obj -> g.apply((GetPortalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPortalResponse> {
        /**
         * <p>
         * The web portal.
         * </p>
         * 
         * @param portal
         *        The web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portal(Portal portal);

        /**
         * <p>
         * The web portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link Portal.Builder} avoiding the need to
         * create one manually via {@link Portal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Portal.Builder#build()} is called immediately and its result is
         * passed to {@link #portal(Portal)}.
         * 
         * @param portal
         *        a consumer that will call methods on {@link Portal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portal(Portal)
         */
        default Builder portal(Consumer<Portal.Builder> portal) {
            return portal(Portal.builder().applyMutation(portal).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private Portal portal;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPortalResponse model) {
            super(model);
            portal(model.portal);
        }

        public final Portal.Builder getPortal() {
            return portal != null ? portal.toBuilder() : null;
        }

        public final void setPortal(Portal.BuilderImpl portal) {
            this.portal = portal != null ? portal.build() : null;
        }

        @Override
        public final Builder portal(Portal portal) {
            this.portal = portal;
            return this;
        }

        @Override
        public GetPortalResponse build() {
            return new GetPortalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
