/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserAccessLoggingSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListUserAccessLoggingSettingsResponse.Builder, ListUserAccessLoggingSettingsResponse> {
    private static final SdkField<List<UserAccessLoggingSettingsSummary>> USER_ACCESS_LOGGING_SETTINGS_FIELD = SdkField
            .<List<UserAccessLoggingSettingsSummary>> builder(MarshallingType.LIST)
            .memberName("userAccessLoggingSettings")
            .getter(getter(ListUserAccessLoggingSettingsResponse::userAccessLoggingSettings))
            .setter(setter(Builder::userAccessLoggingSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAccessLoggingSettingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAccessLoggingSettingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUserAccessLoggingSettingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_ACCESS_LOGGING_SETTINGS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserAccessLoggingSettingsSummary> userAccessLoggingSettings;

    private final String nextToken;

    private ListUserAccessLoggingSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.userAccessLoggingSettings = builder.userAccessLoggingSettings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserAccessLoggingSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserAccessLoggingSettings() {
        return userAccessLoggingSettings != null && !(userAccessLoggingSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user access logging settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserAccessLoggingSettings} method.
     * </p>
     * 
     * @return The user access logging settings.
     */
    public final List<UserAccessLoggingSettingsSummary> userAccessLoggingSettings() {
        return userAccessLoggingSettings;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserAccessLoggingSettings() ? userAccessLoggingSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserAccessLoggingSettingsResponse)) {
            return false;
        }
        ListUserAccessLoggingSettingsResponse other = (ListUserAccessLoggingSettingsResponse) obj;
        return hasUserAccessLoggingSettings() == other.hasUserAccessLoggingSettings()
                && Objects.equals(userAccessLoggingSettings(), other.userAccessLoggingSettings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUserAccessLoggingSettingsResponse")
                .add("UserAccessLoggingSettings", hasUserAccessLoggingSettings() ? userAccessLoggingSettings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userAccessLoggingSettings":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userAccessLoggingSettings", USER_ACCESS_LOGGING_SETTINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserAccessLoggingSettingsResponse, T> g) {
        return obj -> g.apply((ListUserAccessLoggingSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUserAccessLoggingSettingsResponse> {
        /**
         * <p>
         * The user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettings
         *        The user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettings(Collection<UserAccessLoggingSettingsSummary> userAccessLoggingSettings);

        /**
         * <p>
         * The user access logging settings.
         * </p>
         * 
         * @param userAccessLoggingSettings
         *        The user access logging settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettings(UserAccessLoggingSettingsSummary... userAccessLoggingSettings);

        /**
         * <p>
         * The user access logging settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #userAccessLoggingSettings(List<UserAccessLoggingSettingsSummary>)}.
         * 
         * @param userAccessLoggingSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.UserAccessLoggingSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAccessLoggingSettings(java.util.Collection<UserAccessLoggingSettingsSummary>)
         */
        Builder userAccessLoggingSettings(Consumer<UserAccessLoggingSettingsSummary.Builder>... userAccessLoggingSettings);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<UserAccessLoggingSettingsSummary> userAccessLoggingSettings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserAccessLoggingSettingsResponse model) {
            super(model);
            userAccessLoggingSettings(model.userAccessLoggingSettings);
            nextToken(model.nextToken);
        }

        public final List<UserAccessLoggingSettingsSummary.Builder> getUserAccessLoggingSettings() {
            List<UserAccessLoggingSettingsSummary.Builder> result = UserAccessLoggingSettingsListCopier
                    .copyToBuilder(this.userAccessLoggingSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAccessLoggingSettings(
                Collection<UserAccessLoggingSettingsSummary.BuilderImpl> userAccessLoggingSettings) {
            this.userAccessLoggingSettings = UserAccessLoggingSettingsListCopier.copyFromBuilder(userAccessLoggingSettings);
        }

        @Override
        public final Builder userAccessLoggingSettings(Collection<UserAccessLoggingSettingsSummary> userAccessLoggingSettings) {
            this.userAccessLoggingSettings = UserAccessLoggingSettingsListCopier.copy(userAccessLoggingSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessLoggingSettings(UserAccessLoggingSettingsSummary... userAccessLoggingSettings) {
            userAccessLoggingSettings(Arrays.asList(userAccessLoggingSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAccessLoggingSettings(
                Consumer<UserAccessLoggingSettingsSummary.Builder>... userAccessLoggingSettings) {
            userAccessLoggingSettings(Stream.of(userAccessLoggingSettings)
                    .map(c -> UserAccessLoggingSettingsSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUserAccessLoggingSettingsResponse build() {
            return new ListUserAccessLoggingSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
