/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The redaction placeholder that will replace the redacted text in session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedactionPlaceHolder implements SdkPojo, Serializable,
        ToCopyableBuilder<RedactionPlaceHolder.Builder, RedactionPlaceHolder> {
    private static final SdkField<String> REDACTION_PLACE_HOLDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redactionPlaceHolderType").getter(getter(RedactionPlaceHolder::redactionPlaceHolderTypeAsString))
            .setter(setter(Builder::redactionPlaceHolderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactionPlaceHolderType").build())
            .build();

    private static final SdkField<String> REDACTION_PLACE_HOLDER_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redactionPlaceHolderText").getter(getter(RedactionPlaceHolder::redactionPlaceHolderText))
            .setter(setter(Builder::redactionPlaceHolderText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactionPlaceHolderText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REDACTION_PLACE_HOLDER_TYPE_FIELD, REDACTION_PLACE_HOLDER_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String redactionPlaceHolderType;

    private final String redactionPlaceHolderText;

    private RedactionPlaceHolder(BuilderImpl builder) {
        this.redactionPlaceHolderType = builder.redactionPlaceHolderType;
        this.redactionPlaceHolderText = builder.redactionPlaceHolderText;
    }

    /**
     * <p>
     * The redaction placeholder type that will replace the redacted text in session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #redactionPlaceHolderType} will return {@link RedactionPlaceHolderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #redactionPlaceHolderTypeAsString}.
     * </p>
     * 
     * @return The redaction placeholder type that will replace the redacted text in session.
     * @see RedactionPlaceHolderType
     */
    public final RedactionPlaceHolderType redactionPlaceHolderType() {
        return RedactionPlaceHolderType.fromValue(redactionPlaceHolderType);
    }

    /**
     * <p>
     * The redaction placeholder type that will replace the redacted text in session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #redactionPlaceHolderType} will return {@link RedactionPlaceHolderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #redactionPlaceHolderTypeAsString}.
     * </p>
     * 
     * @return The redaction placeholder type that will replace the redacted text in session.
     * @see RedactionPlaceHolderType
     */
    public final String redactionPlaceHolderTypeAsString() {
        return redactionPlaceHolderType;
    }

    /**
     * <p>
     * The redaction placeholder text that will replace the redacted text in session for the custom text redaction
     * placeholder type.
     * </p>
     * 
     * @return The redaction placeholder text that will replace the redacted text in session for the custom text
     *         redaction placeholder type.
     */
    public final String redactionPlaceHolderText() {
        return redactionPlaceHolderText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redactionPlaceHolderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(redactionPlaceHolderText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactionPlaceHolder)) {
            return false;
        }
        RedactionPlaceHolder other = (RedactionPlaceHolder) obj;
        return Objects.equals(redactionPlaceHolderTypeAsString(), other.redactionPlaceHolderTypeAsString())
                && Objects.equals(redactionPlaceHolderText(), other.redactionPlaceHolderText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedactionPlaceHolder").add("RedactionPlaceHolderType", redactionPlaceHolderTypeAsString())
                .add("RedactionPlaceHolderText", redactionPlaceHolderText() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "redactionPlaceHolderType":
            return Optional.ofNullable(clazz.cast(redactionPlaceHolderTypeAsString()));
        case "redactionPlaceHolderText":
            return Optional.ofNullable(clazz.cast(redactionPlaceHolderText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("redactionPlaceHolderType", REDACTION_PLACE_HOLDER_TYPE_FIELD);
        map.put("redactionPlaceHolderText", REDACTION_PLACE_HOLDER_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedactionPlaceHolder, T> g) {
        return obj -> g.apply((RedactionPlaceHolder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedactionPlaceHolder> {
        /**
         * <p>
         * The redaction placeholder type that will replace the redacted text in session.
         * </p>
         * 
         * @param redactionPlaceHolderType
         *        The redaction placeholder type that will replace the redacted text in session.
         * @see RedactionPlaceHolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionPlaceHolderType
         */
        Builder redactionPlaceHolderType(String redactionPlaceHolderType);

        /**
         * <p>
         * The redaction placeholder type that will replace the redacted text in session.
         * </p>
         * 
         * @param redactionPlaceHolderType
         *        The redaction placeholder type that will replace the redacted text in session.
         * @see RedactionPlaceHolderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedactionPlaceHolderType
         */
        Builder redactionPlaceHolderType(RedactionPlaceHolderType redactionPlaceHolderType);

        /**
         * <p>
         * The redaction placeholder text that will replace the redacted text in session for the custom text redaction
         * placeholder type.
         * </p>
         * 
         * @param redactionPlaceHolderText
         *        The redaction placeholder text that will replace the redacted text in session for the custom text
         *        redaction placeholder type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactionPlaceHolderText(String redactionPlaceHolderText);
    }

    static final class BuilderImpl implements Builder {
        private String redactionPlaceHolderType;

        private String redactionPlaceHolderText;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactionPlaceHolder model) {
            redactionPlaceHolderType(model.redactionPlaceHolderType);
            redactionPlaceHolderText(model.redactionPlaceHolderText);
        }

        public final String getRedactionPlaceHolderType() {
            return redactionPlaceHolderType;
        }

        public final void setRedactionPlaceHolderType(String redactionPlaceHolderType) {
            this.redactionPlaceHolderType = redactionPlaceHolderType;
        }

        @Override
        public final Builder redactionPlaceHolderType(String redactionPlaceHolderType) {
            this.redactionPlaceHolderType = redactionPlaceHolderType;
            return this;
        }

        @Override
        public final Builder redactionPlaceHolderType(RedactionPlaceHolderType redactionPlaceHolderType) {
            this.redactionPlaceHolderType(redactionPlaceHolderType == null ? null : redactionPlaceHolderType.toString());
            return this;
        }

        public final String getRedactionPlaceHolderText() {
            return redactionPlaceHolderText;
        }

        public final void setRedactionPlaceHolderText(String redactionPlaceHolderText) {
            this.redactionPlaceHolderText = redactionPlaceHolderText;
        }

        @Override
        public final Builder redactionPlaceHolderText(String redactionPlaceHolderText) {
            this.redactionPlaceHolderText = redactionPlaceHolderText;
            return this;
        }

        @Override
        public RedactionPlaceHolder build() {
            return new RedactionPlaceHolder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
