/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The session logger resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionLogger implements SdkPojo, Serializable, ToCopyableBuilder<SessionLogger.Builder, SessionLogger> {
    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionLoggerArn").getter(getter(SessionLogger::sessionLoggerArn))
            .setter(setter(Builder::sessionLoggerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggerArn").build()).build();

    private static final SdkField<EventFilter> EVENT_FILTER_FIELD = SdkField.<EventFilter> builder(MarshallingType.SDK_POJO)
            .memberName("eventFilter").getter(getter(SessionLogger::eventFilter)).setter(setter(Builder::eventFilter))
            .constructor(EventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFilter").build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(SessionLogger::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(SessionLogger::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(SessionLogger::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(SessionLogger::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(SessionLogger::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(SessionLogger::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_ARN_FIELD,
            EVENT_FILTER_FIELD, LOG_CONFIGURATION_FIELD, CUSTOMER_MANAGED_KEY_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD,
            ASSOCIATED_PORTAL_ARNS_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionLoggerArn;

    private final EventFilter eventFilter;

    private final LogConfiguration logConfiguration;

    private final String customerManagedKey;

    private final Map<String, String> additionalEncryptionContext;

    private final List<String> associatedPortalArns;

    private final String displayName;

    private final Instant creationDate;

    private SessionLogger(BuilderImpl builder) {
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.eventFilter = builder.eventFilter;
        this.logConfiguration = builder.logConfiguration;
        this.customerManagedKey = builder.customerManagedKey;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN of the session logger resource.
     * </p>
     * 
     * @return The ARN of the session logger resource.
     */
    public final String sessionLoggerArn() {
        return sessionLoggerArn;
    }

    /**
     * <p>
     * The filter that specifies which events to monitor.
     * </p>
     * 
     * @return The filter that specifies which events to monitor.
     */
    public final EventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * <p>
     * The configuration that specifies where logs are fowarded.
     * </p>
     * 
     * @return The configuration that specifies where logs are fowarded.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The custom managed key of the session logger.
     * </p>
     * 
     * @return The custom managed key of the session logger.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the session logger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the session logger.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated portal ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return The associated portal ARN.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * The human-readable display name.
     * </p>
     * 
     * @return The human-readable display name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The date the session logger resource was created.
     * </p>
     * 
     * @return The date the session logger resource was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionLogger)) {
            return false;
        }
        SessionLogger other = (SessionLogger) obj;
        return Objects.equals(sessionLoggerArn(), other.sessionLoggerArn()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(customerManagedKey(), other.customerManagedKey())
                && hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionLogger").add("SessionLoggerArn", sessionLoggerArn()).add("EventFilter", eventFilter())
                .add("LogConfiguration", logConfiguration()).add("CustomerManagedKey", customerManagedKey())
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionLoggerArn":
            return Optional.ofNullable(clazz.cast(sessionLoggerArn()));
        case "eventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("eventFilter", EVENT_FILTER_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionLogger, T> g) {
        return obj -> g.apply((SessionLogger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionLogger> {
        /**
         * <p>
         * The ARN of the session logger resource.
         * </p>
         * 
         * @param sessionLoggerArn
         *        The ARN of the session logger resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggerArn(String sessionLoggerArn);

        /**
         * <p>
         * The filter that specifies which events to monitor.
         * </p>
         * 
         * @param eventFilter
         *        The filter that specifies which events to monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(EventFilter eventFilter);

        /**
         * <p>
         * The filter that specifies which events to monitor.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventFilter.Builder} avoiding the need to
         * create one manually via {@link EventFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #eventFilter(EventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link EventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(EventFilter)
         */
        default Builder eventFilter(Consumer<EventFilter.Builder> eventFilter) {
            return eventFilter(EventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * <p>
         * The configuration that specifies where logs are fowarded.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration that specifies where logs are fowarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The configuration that specifies where logs are fowarded.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The custom managed key of the session logger.
         * </p>
         * 
         * @param customerManagedKey
         *        The custom managed key of the session logger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The additional encryption context of the session logger.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the session logger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * The associated portal ARN.
         * </p>
         * 
         * @param associatedPortalArns
         *        The associated portal ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * The associated portal ARN.
         * </p>
         * 
         * @param associatedPortalArns
         *        The associated portal ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * The human-readable display name.
         * </p>
         * 
         * @param displayName
         *        The human-readable display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The date the session logger resource was created.
         * </p>
         * 
         * @param creationDate
         *        The date the session logger resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String sessionLoggerArn;

        private EventFilter eventFilter;

        private LogConfiguration logConfiguration;

        private String customerManagedKey;

        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private String displayName;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionLogger model) {
            sessionLoggerArn(model.sessionLoggerArn);
            eventFilter(model.eventFilter);
            logConfiguration(model.logConfiguration);
            customerManagedKey(model.customerManagedKey);
            additionalEncryptionContext(model.additionalEncryptionContext);
            associatedPortalArns(model.associatedPortalArns);
            displayName(model.displayName);
            creationDate(model.creationDate);
        }

        public final String getSessionLoggerArn() {
            return sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final EventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        public final void setEventFilter(EventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        @Override
        public final Builder eventFilter(EventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public SessionLogger build() {
            return new SessionLogger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
