/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the session logger resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionLoggerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionLoggerSummary.Builder, SessionLoggerSummary> {
    private static final SdkField<String> SESSION_LOGGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionLoggerArn").getter(getter(SessionLoggerSummary::sessionLoggerArn))
            .setter(setter(Builder::sessionLoggerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLoggerArn").build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(SessionLoggerSummary::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(SessionLoggerSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(SessionLoggerSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_LOGGER_ARN_FIELD,
            LOG_CONFIGURATION_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionLoggerArn;

    private final LogConfiguration logConfiguration;

    private final String displayName;

    private final Instant creationDate;

    private SessionLoggerSummary(BuilderImpl builder) {
        this.sessionLoggerArn = builder.sessionLoggerArn;
        this.logConfiguration = builder.logConfiguration;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ARN of the session logger resource.
     * </p>
     * 
     * @return The ARN of the session logger resource.
     */
    public final String sessionLoggerArn() {
        return sessionLoggerArn;
    }

    /**
     * <p>
     * The configuration that specifies where the logs are fowarded.
     * </p>
     * 
     * @return The configuration that specifies where the logs are fowarded.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The human-readable display name.
     * </p>
     * 
     * @return The human-readable display name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The date the session logger resource was created.
     * </p>
     * 
     * @return The date the session logger resource was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionLoggerArn());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionLoggerSummary)) {
            return false;
        }
        SessionLoggerSummary other = (SessionLoggerSummary) obj;
        return Objects.equals(sessionLoggerArn(), other.sessionLoggerArn())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionLoggerSummary").add("SessionLoggerArn", sessionLoggerArn())
                .add("LogConfiguration", logConfiguration())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionLoggerArn":
            return Optional.ofNullable(clazz.cast(sessionLoggerArn()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionLoggerArn", SESSION_LOGGER_ARN_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionLoggerSummary, T> g) {
        return obj -> g.apply((SessionLoggerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionLoggerSummary> {
        /**
         * <p>
         * The ARN of the session logger resource.
         * </p>
         * 
         * @param sessionLoggerArn
         *        The ARN of the session logger resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLoggerArn(String sessionLoggerArn);

        /**
         * <p>
         * The configuration that specifies where the logs are fowarded.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration that specifies where the logs are fowarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The configuration that specifies where the logs are fowarded.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The human-readable display name.
         * </p>
         * 
         * @param displayName
         *        The human-readable display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The date the session logger resource was created.
         * </p>
         * 
         * @param creationDate
         *        The date the session logger resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String sessionLoggerArn;

        private LogConfiguration logConfiguration;

        private String displayName;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionLoggerSummary model) {
            sessionLoggerArn(model.sessionLoggerArn);
            logConfiguration(model.logConfiguration);
            displayName(model.displayName);
            creationDate(model.creationDate);
        }

        public final String getSessionLoggerArn() {
            return sessionLoggerArn;
        }

        public final void setSessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
        }

        @Override
        public final Builder sessionLoggerArn(String sessionLoggerArn) {
            this.sessionLoggerArn = sessionLoggerArn;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public SessionLoggerSummary build() {
            return new SessionLoggerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
