/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIpAccessSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<UpdateIpAccessSettingsResponse.Builder, UpdateIpAccessSettingsResponse> {
    private static final SdkField<IpAccessSettings> IP_ACCESS_SETTINGS_FIELD = SdkField
            .<IpAccessSettings> builder(MarshallingType.SDK_POJO).memberName("ipAccessSettings")
            .getter(getter(UpdateIpAccessSettingsResponse::ipAccessSettings)).setter(setter(Builder::ipAccessSettings))
            .constructor(IpAccessSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ACCESS_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IpAccessSettings ipAccessSettings;

    private UpdateIpAccessSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.ipAccessSettings = builder.ipAccessSettings;
    }

    /**
     * <p>
     * The IP access settings.
     * </p>
     * 
     * @return The IP access settings.
     */
    public final IpAccessSettings ipAccessSettings() {
        return ipAccessSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpAccessSettingsResponse)) {
            return false;
        }
        UpdateIpAccessSettingsResponse other = (UpdateIpAccessSettingsResponse) obj;
        return Objects.equals(ipAccessSettings(), other.ipAccessSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIpAccessSettingsResponse").add("IpAccessSettings", ipAccessSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAccessSettings":
            return Optional.ofNullable(clazz.cast(ipAccessSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ipAccessSettings", IP_ACCESS_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpAccessSettingsResponse, T> g) {
        return obj -> g.apply((UpdateIpAccessSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIpAccessSettingsResponse> {
        /**
         * <p>
         * The IP access settings.
         * </p>
         * 
         * @param ipAccessSettings
         *        The IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettings(IpAccessSettings ipAccessSettings);

        /**
         * <p>
         * The IP access settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpAccessSettings.Builder} avoiding the
         * need to create one manually via {@link IpAccessSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpAccessSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #ipAccessSettings(IpAccessSettings)}.
         * 
         * @param ipAccessSettings
         *        a consumer that will call methods on {@link IpAccessSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAccessSettings(IpAccessSettings)
         */
        default Builder ipAccessSettings(Consumer<IpAccessSettings.Builder> ipAccessSettings) {
            return ipAccessSettings(IpAccessSettings.builder().applyMutation(ipAccessSettings).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private IpAccessSettings ipAccessSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpAccessSettingsResponse model) {
            super(model);
            ipAccessSettings(model.ipAccessSettings);
        }

        public final IpAccessSettings.Builder getIpAccessSettings() {
            return ipAccessSettings != null ? ipAccessSettings.toBuilder() : null;
        }

        public final void setIpAccessSettings(IpAccessSettings.BuilderImpl ipAccessSettings) {
            this.ipAccessSettings = ipAccessSettings != null ? ipAccessSettings.build() : null;
        }

        @Override
        public final Builder ipAccessSettings(IpAccessSettings ipAccessSettings) {
            this.ipAccessSettings = ipAccessSettings;
            return this;
        }

        @Override
        public UpdateIpAccessSettingsResponse build() {
            return new UpdateIpAccessSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
