/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.xray.model.BackendConnectionErrors;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryRecord> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(TelemetryRecord.getter(TelemetryRecord::timestamp)).setter(TelemetryRecord.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<Integer> SEGMENTS_RECEIVED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsReceivedCount").getter(TelemetryRecord.getter(TelemetryRecord::segmentsReceivedCount)).setter(TelemetryRecord.setter(Builder::segmentsReceivedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsReceivedCount").build()}).build();
    private static final SdkField<Integer> SEGMENTS_SENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsSentCount").getter(TelemetryRecord.getter(TelemetryRecord::segmentsSentCount)).setter(TelemetryRecord.setter(Builder::segmentsSentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsSentCount").build()}).build();
    private static final SdkField<Integer> SEGMENTS_SPILLOVER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsSpilloverCount").getter(TelemetryRecord.getter(TelemetryRecord::segmentsSpilloverCount)).setter(TelemetryRecord.setter(Builder::segmentsSpilloverCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsSpilloverCount").build()}).build();
    private static final SdkField<Integer> SEGMENTS_REJECTED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentsRejectedCount").getter(TelemetryRecord.getter(TelemetryRecord::segmentsRejectedCount)).setter(TelemetryRecord.setter(Builder::segmentsRejectedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentsRejectedCount").build()}).build();
    private static final SdkField<BackendConnectionErrors> BACKEND_CONNECTION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackendConnectionErrors").getter(TelemetryRecord.getter(TelemetryRecord::backendConnectionErrors)).setter(TelemetryRecord.setter(Builder::backendConnectionErrors)).constructor(BackendConnectionErrors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackendConnectionErrors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, SEGMENTS_RECEIVED_COUNT_FIELD, SEGMENTS_SENT_COUNT_FIELD, SEGMENTS_SPILLOVER_COUNT_FIELD, SEGMENTS_REJECTED_COUNT_FIELD, BACKEND_CONNECTION_ERRORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final Integer segmentsReceivedCount;
    private final Integer segmentsSentCount;
    private final Integer segmentsSpilloverCount;
    private final Integer segmentsRejectedCount;
    private final BackendConnectionErrors backendConnectionErrors;

    private TelemetryRecord(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.segmentsReceivedCount = builder.segmentsReceivedCount;
        this.segmentsSentCount = builder.segmentsSentCount;
        this.segmentsSpilloverCount = builder.segmentsSpilloverCount;
        this.segmentsRejectedCount = builder.segmentsRejectedCount;
        this.backendConnectionErrors = builder.backendConnectionErrors;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Integer segmentsReceivedCount() {
        return this.segmentsReceivedCount;
    }

    public Integer segmentsSentCount() {
        return this.segmentsSentCount;
    }

    public Integer segmentsSpilloverCount() {
        return this.segmentsSpilloverCount;
    }

    public Integer segmentsRejectedCount() {
        return this.segmentsRejectedCount;
    }

    public BackendConnectionErrors backendConnectionErrors() {
        return this.backendConnectionErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsReceivedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsSentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsSpilloverCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsRejectedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendConnectionErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRecord)) {
            return false;
        }
        TelemetryRecord other = (TelemetryRecord)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.segmentsReceivedCount(), other.segmentsReceivedCount()) && Objects.equals(this.segmentsSentCount(), other.segmentsSentCount()) && Objects.equals(this.segmentsSpilloverCount(), other.segmentsSpilloverCount()) && Objects.equals(this.segmentsRejectedCount(), other.segmentsRejectedCount()) && Objects.equals(this.backendConnectionErrors(), other.backendConnectionErrors());
    }

    public String toString() {
        return ToString.builder((String)"TelemetryRecord").add("Timestamp", (Object)this.timestamp()).add("SegmentsReceivedCount", (Object)this.segmentsReceivedCount()).add("SegmentsSentCount", (Object)this.segmentsSentCount()).add("SegmentsSpilloverCount", (Object)this.segmentsSpilloverCount()).add("SegmentsRejectedCount", (Object)this.segmentsRejectedCount()).add("BackendConnectionErrors", (Object)this.backendConnectionErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "SegmentsReceivedCount": {
                return Optional.ofNullable(clazz.cast(this.segmentsReceivedCount()));
            }
            case "SegmentsSentCount": {
                return Optional.ofNullable(clazz.cast(this.segmentsSentCount()));
            }
            case "SegmentsSpilloverCount": {
                return Optional.ofNullable(clazz.cast(this.segmentsSpilloverCount()));
            }
            case "SegmentsRejectedCount": {
                return Optional.ofNullable(clazz.cast(this.segmentsRejectedCount()));
            }
            case "BackendConnectionErrors": {
                return Optional.ofNullable(clazz.cast(this.backendConnectionErrors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TelemetryRecord, T> g) {
        return obj -> g.apply((TelemetryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Integer segmentsReceivedCount;
        private Integer segmentsSentCount;
        private Integer segmentsSpilloverCount;
        private Integer segmentsRejectedCount;
        private BackendConnectionErrors backendConnectionErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRecord model) {
            this.timestamp(model.timestamp);
            this.segmentsReceivedCount(model.segmentsReceivedCount);
            this.segmentsSentCount(model.segmentsSentCount);
            this.segmentsSpilloverCount(model.segmentsSpilloverCount);
            this.segmentsRejectedCount(model.segmentsRejectedCount);
            this.backendConnectionErrors(model.backendConnectionErrors);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getSegmentsReceivedCount() {
            return this.segmentsReceivedCount;
        }

        @Override
        public final Builder segmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
            return this;
        }

        public final void setSegmentsReceivedCount(Integer segmentsReceivedCount) {
            this.segmentsReceivedCount = segmentsReceivedCount;
        }

        public final Integer getSegmentsSentCount() {
            return this.segmentsSentCount;
        }

        @Override
        public final Builder segmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
            return this;
        }

        public final void setSegmentsSentCount(Integer segmentsSentCount) {
            this.segmentsSentCount = segmentsSentCount;
        }

        public final Integer getSegmentsSpilloverCount() {
            return this.segmentsSpilloverCount;
        }

        @Override
        public final Builder segmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
            return this;
        }

        public final void setSegmentsSpilloverCount(Integer segmentsSpilloverCount) {
            this.segmentsSpilloverCount = segmentsSpilloverCount;
        }

        public final Integer getSegmentsRejectedCount() {
            return this.segmentsRejectedCount;
        }

        @Override
        public final Builder segmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
            return this;
        }

        public final void setSegmentsRejectedCount(Integer segmentsRejectedCount) {
            this.segmentsRejectedCount = segmentsRejectedCount;
        }

        public final BackendConnectionErrors.Builder getBackendConnectionErrors() {
            return this.backendConnectionErrors != null ? this.backendConnectionErrors.toBuilder() : null;
        }

        @Override
        public final Builder backendConnectionErrors(BackendConnectionErrors backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors;
            return this;
        }

        public final void setBackendConnectionErrors(BackendConnectionErrors.BuilderImpl backendConnectionErrors) {
            this.backendConnectionErrors = backendConnectionErrors != null ? backendConnectionErrors.build() : null;
        }

        public TelemetryRecord build() {
            return new TelemetryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryRecord> {
        public Builder timestamp(Instant var1);

        public Builder segmentsReceivedCount(Integer var1);

        public Builder segmentsSentCount(Integer var1);

        public Builder segmentsSpilloverCount(Integer var1);

        public Builder segmentsRejectedCount(Integer var1);

        public Builder backendConnectionErrors(BackendConnectionErrors var1);

        default public Builder backendConnectionErrors(Consumer<BackendConnectionErrors.Builder> backendConnectionErrors) {
            return this.backendConnectionErrors((BackendConnectionErrors)((BackendConnectionErrors.Builder)BackendConnectionErrors.builder().applyMutation(backendConnectionErrors)).build());
        }
    }
}

