/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightRequest extends XRayRequest implements
        ToCopyableBuilder<GetInsightRequest.Builder, GetInsightRequest> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightId").getter(getter(GetInsightRequest::insightId)).setter(setter(Builder::insightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD));

    private final String insightId;

    private GetInsightRequest(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
    }

    /**
     * <p>
     * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     * </p>
     * 
     * @return The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
     */
    public final String insightId() {
        return insightId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightRequest)) {
            return false;
        }
        GetInsightRequest other = (GetInsightRequest) obj;
        return Objects.equals(insightId(), other.insightId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInsightRequest").add("InsightId", insightId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightId":
            return Optional.ofNullable(clazz.cast(insightId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightRequest, T> g) {
        return obj -> g.apply((GetInsightRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightRequest> {
        /**
         * <p>
         * The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
         * </p>
         * 
         * @param insightId
         *        The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightId(String insightId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String insightId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightRequest model) {
            super(model);
            insightId(model.insightId);
        }

        public final String getInsightId() {
            return insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInsightRequest build() {
            return new GetInsightRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
