/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSamplingTargetsResponse extends XRayResponse implements
        ToCopyableBuilder<GetSamplingTargetsResponse.Builder, GetSamplingTargetsResponse> {
    private static final SdkField<List<SamplingTargetDocument>> SAMPLING_TARGET_DOCUMENTS_FIELD = SdkField
            .<List<SamplingTargetDocument>> builder(MarshallingType.LIST)
            .memberName("SamplingTargetDocuments")
            .getter(getter(GetSamplingTargetsResponse::samplingTargetDocuments))
            .setter(setter(Builder::samplingTargetDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingTargetDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SamplingTargetDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(SamplingTargetDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_RULE_MODIFICATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRuleModification").getter(getter(GetSamplingTargetsResponse::lastRuleModification))
            .setter(setter(Builder::lastRuleModification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRuleModification").build())
            .build();

    private static final SdkField<List<UnprocessedStatistics>> UNPROCESSED_STATISTICS_FIELD = SdkField
            .<List<UnprocessedStatistics>> builder(MarshallingType.LIST)
            .memberName("UnprocessedStatistics")
            .getter(getter(GetSamplingTargetsResponse::unprocessedStatistics))
            .setter(setter(Builder::unprocessedStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedStatistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedStatistics> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedStatistics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAMPLING_TARGET_DOCUMENTS_FIELD, LAST_RULE_MODIFICATION_FIELD, UNPROCESSED_STATISTICS_FIELD));

    private final List<SamplingTargetDocument> samplingTargetDocuments;

    private final Instant lastRuleModification;

    private final List<UnprocessedStatistics> unprocessedStatistics;

    private GetSamplingTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.samplingTargetDocuments = builder.samplingTargetDocuments;
        this.lastRuleModification = builder.lastRuleModification;
        this.unprocessedStatistics = builder.unprocessedStatistics;
    }

    /**
     * Returns true if the SamplingTargetDocuments property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSamplingTargetDocuments() {
        return samplingTargetDocuments != null && !(samplingTargetDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updated rules that the service should use to sample requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSamplingTargetDocuments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Updated rules that the service should use to sample requests.
     */
    public final List<SamplingTargetDocument> samplingTargetDocuments() {
        return samplingTargetDocuments;
    }

    /**
     * <p>
     * The last time a user changed the sampling rule configuration. If the sampling rule configuration changed since
     * the service last retrieved it, the service should call <a>GetSamplingRules</a> to get the latest version.
     * </p>
     * 
     * @return The last time a user changed the sampling rule configuration. If the sampling rule configuration changed
     *         since the service last retrieved it, the service should call <a>GetSamplingRules</a> to get the latest
     *         version.
     */
    public final Instant lastRuleModification() {
        return lastRuleModification;
    }

    /**
     * Returns true if the UnprocessedStatistics property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedStatistics() {
        return unprocessedStatistics != null && !(unprocessedStatistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedStatistics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
     */
    public final List<UnprocessedStatistics> unprocessedStatistics() {
        return unprocessedStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSamplingTargetDocuments() ? samplingTargetDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastRuleModification());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedStatistics() ? unprocessedStatistics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamplingTargetsResponse)) {
            return false;
        }
        GetSamplingTargetsResponse other = (GetSamplingTargetsResponse) obj;
        return hasSamplingTargetDocuments() == other.hasSamplingTargetDocuments()
                && Objects.equals(samplingTargetDocuments(), other.samplingTargetDocuments())
                && Objects.equals(lastRuleModification(), other.lastRuleModification())
                && hasUnprocessedStatistics() == other.hasUnprocessedStatistics()
                && Objects.equals(unprocessedStatistics(), other.unprocessedStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSamplingTargetsResponse")
                .add("SamplingTargetDocuments", hasSamplingTargetDocuments() ? samplingTargetDocuments() : null)
                .add("LastRuleModification", lastRuleModification())
                .add("UnprocessedStatistics", hasUnprocessedStatistics() ? unprocessedStatistics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamplingTargetDocuments":
            return Optional.ofNullable(clazz.cast(samplingTargetDocuments()));
        case "LastRuleModification":
            return Optional.ofNullable(clazz.cast(lastRuleModification()));
        case "UnprocessedStatistics":
            return Optional.ofNullable(clazz.cast(unprocessedStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamplingTargetsResponse, T> g) {
        return obj -> g.apply((GetSamplingTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSamplingTargetsResponse> {
        /**
         * <p>
         * Updated rules that the service should use to sample requests.
         * </p>
         * 
         * @param samplingTargetDocuments
         *        Updated rules that the service should use to sample requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingTargetDocuments(Collection<SamplingTargetDocument> samplingTargetDocuments);

        /**
         * <p>
         * Updated rules that the service should use to sample requests.
         * </p>
         * 
         * @param samplingTargetDocuments
         *        Updated rules that the service should use to sample requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingTargetDocuments(SamplingTargetDocument... samplingTargetDocuments);

        /**
         * <p>
         * Updated rules that the service should use to sample requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SamplingTargetDocument>.Builder} avoiding
         * the need to create one manually via {@link List<SamplingTargetDocument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SamplingTargetDocument>.Builder#build()} is called
         * immediately and its result is passed to {@link #samplingTargetDocuments(List<SamplingTargetDocument>)}.
         * 
         * @param samplingTargetDocuments
         *        a consumer that will call methods on {@link List<SamplingTargetDocument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samplingTargetDocuments(List<SamplingTargetDocument>)
         */
        Builder samplingTargetDocuments(Consumer<SamplingTargetDocument.Builder>... samplingTargetDocuments);

        /**
         * <p>
         * The last time a user changed the sampling rule configuration. If the sampling rule configuration changed
         * since the service last retrieved it, the service should call <a>GetSamplingRules</a> to get the latest
         * version.
         * </p>
         * 
         * @param lastRuleModification
         *        The last time a user changed the sampling rule configuration. If the sampling rule configuration
         *        changed since the service last retrieved it, the service should call <a>GetSamplingRules</a> to get
         *        the latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRuleModification(Instant lastRuleModification);

        /**
         * <p>
         * Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
         * </p>
         * 
         * @param unprocessedStatistics
         *        Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedStatistics(Collection<UnprocessedStatistics> unprocessedStatistics);

        /**
         * <p>
         * Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
         * </p>
         * 
         * @param unprocessedStatistics
         *        Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedStatistics(UnprocessedStatistics... unprocessedStatistics);

        /**
         * <p>
         * Information about <a>SamplingStatisticsDocument</a> that X-Ray could not process.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedStatistics>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedStatistics>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedStatistics>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedStatistics(List<UnprocessedStatistics>)}.
         * 
         * @param unprocessedStatistics
         *        a consumer that will call methods on {@link List<UnprocessedStatistics>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedStatistics(List<UnprocessedStatistics>)
         */
        Builder unprocessedStatistics(Consumer<UnprocessedStatistics.Builder>... unprocessedStatistics);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private List<SamplingTargetDocument> samplingTargetDocuments = DefaultSdkAutoConstructList.getInstance();

        private Instant lastRuleModification;

        private List<UnprocessedStatistics> unprocessedStatistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamplingTargetsResponse model) {
            super(model);
            samplingTargetDocuments(model.samplingTargetDocuments);
            lastRuleModification(model.lastRuleModification);
            unprocessedStatistics(model.unprocessedStatistics);
        }

        public final List<SamplingTargetDocument.Builder> getSamplingTargetDocuments() {
            List<SamplingTargetDocument.Builder> result = SamplingTargetDocumentListCopier
                    .copyToBuilder(this.samplingTargetDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder samplingTargetDocuments(Collection<SamplingTargetDocument> samplingTargetDocuments) {
            this.samplingTargetDocuments = SamplingTargetDocumentListCopier.copy(samplingTargetDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingTargetDocuments(SamplingTargetDocument... samplingTargetDocuments) {
            samplingTargetDocuments(Arrays.asList(samplingTargetDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samplingTargetDocuments(Consumer<SamplingTargetDocument.Builder>... samplingTargetDocuments) {
            samplingTargetDocuments(Stream.of(samplingTargetDocuments)
                    .map(c -> SamplingTargetDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamplingTargetDocuments(Collection<SamplingTargetDocument.BuilderImpl> samplingTargetDocuments) {
            this.samplingTargetDocuments = SamplingTargetDocumentListCopier.copyFromBuilder(samplingTargetDocuments);
        }

        public final Instant getLastRuleModification() {
            return lastRuleModification;
        }

        @Override
        public final Builder lastRuleModification(Instant lastRuleModification) {
            this.lastRuleModification = lastRuleModification;
            return this;
        }

        public final void setLastRuleModification(Instant lastRuleModification) {
            this.lastRuleModification = lastRuleModification;
        }

        public final List<UnprocessedStatistics.Builder> getUnprocessedStatistics() {
            List<UnprocessedStatistics.Builder> result = UnprocessedStatisticsListCopier
                    .copyToBuilder(this.unprocessedStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unprocessedStatistics(Collection<UnprocessedStatistics> unprocessedStatistics) {
            this.unprocessedStatistics = UnprocessedStatisticsListCopier.copy(unprocessedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedStatistics(UnprocessedStatistics... unprocessedStatistics) {
            unprocessedStatistics(Arrays.asList(unprocessedStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedStatistics(Consumer<UnprocessedStatistics.Builder>... unprocessedStatistics) {
            unprocessedStatistics(Stream.of(unprocessedStatistics)
                    .map(c -> UnprocessedStatistics.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedStatistics(Collection<UnprocessedStatistics.BuilderImpl> unprocessedStatistics) {
            this.unprocessedStatistics = UnprocessedStatisticsListCopier.copyFromBuilder(unprocessedStatistics);
        }

        @Override
        public GetSamplingTargetsResponse build() {
            return new GetSamplingTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
