/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Value of a segment annotation. Has one of three value types: Number, Boolean, or String.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationValue implements SdkPojo, Serializable, ToCopyableBuilder<AnnotationValue.Builder, AnnotationValue> {
    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("NumberValue").getter(getter(AnnotationValue::numberValue)).setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BooleanValue").getter(getter(AnnotationValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StringValue").getter(getter(AnnotationValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_VALUE_FIELD,
            BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double numberValue;

    private final Boolean booleanValue;

    private final String stringValue;

    private AnnotationValue(BuilderImpl builder) {
        this.numberValue = builder.numberValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
    }

    /**
     * <p>
     * Value for a Number annotation.
     * </p>
     * 
     * @return Value for a Number annotation.
     */
    public final Double numberValue() {
        return numberValue;
    }

    /**
     * <p>
     * Value for a Boolean annotation.
     * </p>
     * 
     * @return Value for a Boolean annotation.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * Value for a String annotation.
     * </p>
     * 
     * @return Value for a String annotation.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationValue)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue) obj;
        return Objects.equals(numberValue(), other.numberValue()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationValue").add("NumberValue", numberValue()).add("BooleanValue", booleanValue())
                .add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        case "BooleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "StringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnnotationValue, T> g) {
        return obj -> g.apply((AnnotationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationValue> {
        /**
         * <p>
         * Value for a Number annotation.
         * </p>
         * 
         * @param numberValue
         *        Value for a Number annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(Double numberValue);

        /**
         * <p>
         * Value for a Boolean annotation.
         * </p>
         * 
         * @param booleanValue
         *        Value for a Boolean annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * Value for a String annotation.
         * </p>
         * 
         * @param stringValue
         *        Value for a String annotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Double numberValue;

        private Boolean booleanValue;

        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationValue model) {
            numberValue(model.numberValue);
            booleanValue(model.booleanValue);
            stringValue(model.stringValue);
        }

        public final Double getNumberValue() {
            return numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            this.numberValue = numberValue;
        }

        @Override
        @Transient
        public final Builder numberValue(Double numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        @Transient
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        @Transient
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        @Override
        public AnnotationValue build() {
            return new AnnotationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
