/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightImpactGraphResponse extends XRayResponse implements
        ToCopyableBuilder<GetInsightImpactGraphResponse.Builder, GetInsightImpactGraphResponse> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightId").getter(getter(GetInsightImpactGraphResponse::insightId)).setter(setter(Builder::insightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetInsightImpactGraphResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetInsightImpactGraphResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> SERVICE_GRAPH_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ServiceGraphStartTime").getter(getter(GetInsightImpactGraphResponse::serviceGraphStartTime))
            .setter(setter(Builder::serviceGraphStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceGraphStartTime").build())
            .build();

    private static final SdkField<Instant> SERVICE_GRAPH_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ServiceGraphEndTime").getter(getter(GetInsightImpactGraphResponse::serviceGraphEndTime))
            .setter(setter(Builder::serviceGraphEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceGraphEndTime").build())
            .build();

    private static final SdkField<List<InsightImpactGraphService>> SERVICES_FIELD = SdkField
            .<List<InsightImpactGraphService>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(GetInsightImpactGraphResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InsightImpactGraphService> builder(MarshallingType.SDK_POJO)
                                            .constructor(InsightImpactGraphService::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInsightImpactGraphResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, SERVICE_GRAPH_START_TIME_FIELD, SERVICE_GRAPH_END_TIME_FIELD, SERVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final String insightId;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant serviceGraphStartTime;

    private final Instant serviceGraphEndTime;

    private final List<InsightImpactGraphService> services;

    private final String nextToken;

    private GetInsightImpactGraphResponse(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceGraphStartTime = builder.serviceGraphStartTime;
        this.serviceGraphEndTime = builder.serviceGraphEndTime;
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The insight's unique identifier.
     * </p>
     * 
     * @return The insight's unique identifier.
     */
    public final String insightId() {
        return insightId;
    }

    /**
     * <p>
     * The provided start time.
     * </p>
     * 
     * @return The provided start time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The provided end time.
     * </p>
     * 
     * @return The provided end time.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time, in Unix seconds, at which the service graph started.
     * </p>
     * 
     * @return The time, in Unix seconds, at which the service graph started.
     */
    public final Instant serviceGraphStartTime() {
        return serviceGraphStartTime;
    }

    /**
     * <p>
     * The time, in Unix seconds, at which the service graph ended.
     * </p>
     * 
     * @return The time, in Unix seconds, at which the service graph ended.
     */
    public final Instant serviceGraphEndTime() {
        return serviceGraphEndTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services instrumented services related to the insight.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The Amazon Web Services instrumented services related to the insight.
     */
    public final List<InsightImpactGraphService> services() {
        return services;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(serviceGraphStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(serviceGraphEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightImpactGraphResponse)) {
            return false;
        }
        GetInsightImpactGraphResponse other = (GetInsightImpactGraphResponse) obj;
        return Objects.equals(insightId(), other.insightId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(serviceGraphStartTime(), other.serviceGraphStartTime())
                && Objects.equals(serviceGraphEndTime(), other.serviceGraphEndTime()) && hasServices() == other.hasServices()
                && Objects.equals(services(), other.services()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInsightImpactGraphResponse").add("InsightId", insightId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("ServiceGraphStartTime", serviceGraphStartTime())
                .add("ServiceGraphEndTime", serviceGraphEndTime()).add("Services", hasServices() ? services() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightId":
            return Optional.ofNullable(clazz.cast(insightId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ServiceGraphStartTime":
            return Optional.ofNullable(clazz.cast(serviceGraphStartTime()));
        case "ServiceGraphEndTime":
            return Optional.ofNullable(clazz.cast(serviceGraphEndTime()));
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightImpactGraphResponse, T> g) {
        return obj -> g.apply((GetInsightImpactGraphResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightImpactGraphResponse> {
        /**
         * <p>
         * The insight's unique identifier.
         * </p>
         * 
         * @param insightId
         *        The insight's unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightId(String insightId);

        /**
         * <p>
         * The provided start time.
         * </p>
         * 
         * @param startTime
         *        The provided start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The provided end time.
         * </p>
         * 
         * @param endTime
         *        The provided end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time, in Unix seconds, at which the service graph started.
         * </p>
         * 
         * @param serviceGraphStartTime
         *        The time, in Unix seconds, at which the service graph started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceGraphStartTime(Instant serviceGraphStartTime);

        /**
         * <p>
         * The time, in Unix seconds, at which the service graph ended.
         * </p>
         * 
         * @param serviceGraphEndTime
         *        The time, in Unix seconds, at which the service graph ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceGraphEndTime(Instant serviceGraphEndTime);

        /**
         * <p>
         * The Amazon Web Services instrumented services related to the insight.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services instrumented services related to the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<InsightImpactGraphService> services);

        /**
         * <p>
         * The Amazon Web Services instrumented services related to the insight.
         * </p>
         * 
         * @param services
         *        The Amazon Web Services instrumented services related to the insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(InsightImpactGraphService... services);

        /**
         * <p>
         * The Amazon Web Services instrumented services related to the insight.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InsightImpactGraphService>.Builder}
         * avoiding the need to create one manually via {@link List<InsightImpactGraphService>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InsightImpactGraphService>.Builder#build()} is called
         * immediately and its result is passed to {@link #services(List<InsightImpactGraphService>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<InsightImpactGraphService>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<InsightImpactGraphService>)
         */
        Builder services(Consumer<InsightImpactGraphService.Builder>... services);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends XRayResponse.BuilderImpl implements Builder {
        private String insightId;

        private Instant startTime;

        private Instant endTime;

        private Instant serviceGraphStartTime;

        private Instant serviceGraphEndTime;

        private List<InsightImpactGraphService> services = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightImpactGraphResponse model) {
            super(model);
            insightId(model.insightId);
            startTime(model.startTime);
            endTime(model.endTime);
            serviceGraphStartTime(model.serviceGraphStartTime);
            serviceGraphEndTime(model.serviceGraphEndTime);
            services(model.services);
            nextToken(model.nextToken);
        }

        public final String getInsightId() {
            return insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        @Transient
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getServiceGraphStartTime() {
            return serviceGraphStartTime;
        }

        public final void setServiceGraphStartTime(Instant serviceGraphStartTime) {
            this.serviceGraphStartTime = serviceGraphStartTime;
        }

        @Override
        @Transient
        public final Builder serviceGraphStartTime(Instant serviceGraphStartTime) {
            this.serviceGraphStartTime = serviceGraphStartTime;
            return this;
        }

        public final Instant getServiceGraphEndTime() {
            return serviceGraphEndTime;
        }

        public final void setServiceGraphEndTime(Instant serviceGraphEndTime) {
            this.serviceGraphEndTime = serviceGraphEndTime;
        }

        @Override
        @Transient
        public final Builder serviceGraphEndTime(Instant serviceGraphEndTime) {
            this.serviceGraphEndTime = serviceGraphEndTime;
            return this;
        }

        public final List<InsightImpactGraphService.Builder> getServices() {
            List<InsightImpactGraphService.Builder> result = InsightImpactGraphServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<InsightImpactGraphService.BuilderImpl> services) {
            this.services = InsightImpactGraphServiceListCopier.copyFromBuilder(services);
        }

        @Override
        @Transient
        public final Builder services(Collection<InsightImpactGraphService> services) {
            this.services = InsightImpactGraphServiceListCopier.copy(services);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(InsightImpactGraphService... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(Consumer<InsightImpactGraphService.Builder>... services) {
            services(Stream.of(services).map(c -> InsightImpactGraphService.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetInsightImpactGraphResponse build() {
            return new GetInsightImpactGraphResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
