/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an HTTP request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Http implements SdkPojo, Serializable, ToCopyableBuilder<Http.Builder, Http> {
    private static final SdkField<String> HTTP_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpURL").getter(getter(Http::httpURL)).setter(setter(Builder::httpURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpURL").build()).build();

    private static final SdkField<Integer> HTTP_STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpStatus").getter(getter(Http::httpStatus)).setter(setter(Builder::httpStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpStatus").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpMethod").getter(getter(Http::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()).build();

    private static final SdkField<String> USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserAgent").getter(getter(Http::userAgent)).setter(setter(Builder::userAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAgent").build()).build();

    private static final SdkField<String> CLIENT_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientIp").getter(getter(Http::clientIp)).setter(setter(Builder::clientIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_URL_FIELD,
            HTTP_STATUS_FIELD, HTTP_METHOD_FIELD, USER_AGENT_FIELD, CLIENT_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpURL;

    private final Integer httpStatus;

    private final String httpMethod;

    private final String userAgent;

    private final String clientIp;

    private Http(BuilderImpl builder) {
        this.httpURL = builder.httpURL;
        this.httpStatus = builder.httpStatus;
        this.httpMethod = builder.httpMethod;
        this.userAgent = builder.userAgent;
        this.clientIp = builder.clientIp;
    }

    /**
     * <p>
     * The request URL.
     * </p>
     * 
     * @return The request URL.
     */
    public final String httpURL() {
        return httpURL;
    }

    /**
     * <p>
     * The response status.
     * </p>
     * 
     * @return The response status.
     */
    public final Integer httpStatus() {
        return httpStatus;
    }

    /**
     * <p>
     * The request method.
     * </p>
     * 
     * @return The request method.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * The request's user agent string.
     * </p>
     * 
     * @return The request's user agent string.
     */
    public final String userAgent() {
        return userAgent;
    }

    /**
     * <p>
     * The IP address of the requestor.
     * </p>
     * 
     * @return The IP address of the requestor.
     */
    public final String clientIp() {
        return clientIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpURL());
        hashCode = 31 * hashCode + Objects.hashCode(httpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(clientIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http) obj;
        return Objects.equals(httpURL(), other.httpURL()) && Objects.equals(httpStatus(), other.httpStatus())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(userAgent(), other.userAgent())
                && Objects.equals(clientIp(), other.clientIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Http").add("HttpURL", httpURL()).add("HttpStatus", httpStatus()).add("HttpMethod", httpMethod())
                .add("UserAgent", userAgent()).add("ClientIp", clientIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpURL":
            return Optional.ofNullable(clazz.cast(httpURL()));
        case "HttpStatus":
            return Optional.ofNullable(clazz.cast(httpStatus()));
        case "HttpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "UserAgent":
            return Optional.ofNullable(clazz.cast(userAgent()));
        case "ClientIp":
            return Optional.ofNullable(clazz.cast(clientIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Http, T> g) {
        return obj -> g.apply((Http) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Http> {
        /**
         * <p>
         * The request URL.
         * </p>
         * 
         * @param httpURL
         *        The request URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpURL(String httpURL);

        /**
         * <p>
         * The response status.
         * </p>
         * 
         * @param httpStatus
         *        The response status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpStatus(Integer httpStatus);

        /**
         * <p>
         * The request method.
         * </p>
         * 
         * @param httpMethod
         *        The request method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The request's user agent string.
         * </p>
         * 
         * @param userAgent
         *        The request's user agent string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAgent(String userAgent);

        /**
         * <p>
         * The IP address of the requestor.
         * </p>
         * 
         * @param clientIp
         *        The IP address of the requestor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIp(String clientIp);
    }

    static final class BuilderImpl implements Builder {
        private String httpURL;

        private Integer httpStatus;

        private String httpMethod;

        private String userAgent;

        private String clientIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Http model) {
            httpURL(model.httpURL);
            httpStatus(model.httpStatus);
            httpMethod(model.httpMethod);
            userAgent(model.userAgent);
            clientIp(model.clientIp);
        }

        public final String getHttpURL() {
            return httpURL;
        }

        public final void setHttpURL(String httpURL) {
            this.httpURL = httpURL;
        }

        @Override
        @Transient
        public final Builder httpURL(String httpURL) {
            this.httpURL = httpURL;
            return this;
        }

        public final Integer getHttpStatus() {
            return httpStatus;
        }

        public final void setHttpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
        }

        @Override
        @Transient
        public final Builder httpStatus(Integer httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getUserAgent() {
            return userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        @Transient
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final String getClientIp() {
            return clientIp;
        }

        public final void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        @Override
        @Transient
        public final Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        @Override
        public Http build() {
            return new Http(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
