/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTraceSegmentsRequest extends XRayRequest implements
        ToCopyableBuilder<PutTraceSegmentsRequest.Builder, PutTraceSegmentsRequest> {
    private static final SdkField<List<String>> TRACE_SEGMENT_DOCUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TraceSegmentDocuments")
            .getter(getter(PutTraceSegmentsRequest::traceSegmentDocuments))
            .setter(setter(Builder::traceSegmentDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceSegmentDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TRACE_SEGMENT_DOCUMENTS_FIELD));

    private final List<String> traceSegmentDocuments;

    private PutTraceSegmentsRequest(BuilderImpl builder) {
        super(builder);
        this.traceSegmentDocuments = builder.traceSegmentDocuments;
    }

    /**
     * For responses, this returns true if the service returned a value for the TraceSegmentDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTraceSegmentDocuments() {
        return traceSegmentDocuments != null && !(traceSegmentDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string containing a JSON document defining one or more segments or subsegments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTraceSegmentDocuments} method.
     * </p>
     * 
     * @return A string containing a JSON document defining one or more segments or subsegments.
     */
    public final List<String> traceSegmentDocuments() {
        return traceSegmentDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTraceSegmentDocuments() ? traceSegmentDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTraceSegmentsRequest)) {
            return false;
        }
        PutTraceSegmentsRequest other = (PutTraceSegmentsRequest) obj;
        return hasTraceSegmentDocuments() == other.hasTraceSegmentDocuments()
                && Objects.equals(traceSegmentDocuments(), other.traceSegmentDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTraceSegmentsRequest")
                .add("TraceSegmentDocuments", hasTraceSegmentDocuments() ? traceSegmentDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TraceSegmentDocuments":
            return Optional.ofNullable(clazz.cast(traceSegmentDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTraceSegmentsRequest, T> g) {
        return obj -> g.apply((PutTraceSegmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutTraceSegmentsRequest> {
        /**
         * <p>
         * A string containing a JSON document defining one or more segments or subsegments.
         * </p>
         * 
         * @param traceSegmentDocuments
         *        A string containing a JSON document defining one or more segments or subsegments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceSegmentDocuments(Collection<String> traceSegmentDocuments);

        /**
         * <p>
         * A string containing a JSON document defining one or more segments or subsegments.
         * </p>
         * 
         * @param traceSegmentDocuments
         *        A string containing a JSON document defining one or more segments or subsegments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceSegmentDocuments(String... traceSegmentDocuments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private List<String> traceSegmentDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTraceSegmentsRequest model) {
            super(model);
            traceSegmentDocuments(model.traceSegmentDocuments);
        }

        public final Collection<String> getTraceSegmentDocuments() {
            if (traceSegmentDocuments instanceof SdkAutoConstructList) {
                return null;
            }
            return traceSegmentDocuments;
        }

        public final void setTraceSegmentDocuments(Collection<String> traceSegmentDocuments) {
            this.traceSegmentDocuments = TraceSegmentDocumentListCopier.copy(traceSegmentDocuments);
        }

        @Override
        @Transient
        public final Builder traceSegmentDocuments(Collection<String> traceSegmentDocuments) {
            this.traceSegmentDocuments = TraceSegmentDocumentListCopier.copy(traceSegmentDocuments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder traceSegmentDocuments(String... traceSegmentDocuments) {
            traceSegmentDocuments(Arrays.asList(traceSegmentDocuments));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTraceSegmentsRequest build() {
            return new PutTraceSegmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
