/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Temporary changes to a sampling rule configuration. To meet the global sampling target for a rule, X-Ray calculates a
 * new reservoir for each service based on the recent sampling results of all services that called <a
 * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamplingTargetDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<SamplingTargetDocument.Builder, SamplingTargetDocument> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(SamplingTargetDocument::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<Double> FIXED_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedRate").getter(getter(SamplingTargetDocument::fixedRate)).setter(setter(Builder::fixedRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedRate").build()).build();

    private static final SdkField<Integer> RESERVOIR_QUOTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReservoirQuota").getter(getter(SamplingTargetDocument::reservoirQuota))
            .setter(setter(Builder::reservoirQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirQuota").build()).build();

    private static final SdkField<Instant> RESERVOIR_QUOTA_TTL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReservoirQuotaTTL").getter(getter(SamplingTargetDocument::reservoirQuotaTTL))
            .setter(setter(Builder::reservoirQuotaTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservoirQuotaTTL").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval").getter(getter(SamplingTargetDocument::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            FIXED_RATE_FIELD, RESERVOIR_QUOTA_FIELD, RESERVOIR_QUOTA_TTL_FIELD, INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final Double fixedRate;

    private final Integer reservoirQuota;

    private final Instant reservoirQuotaTTL;

    private final Integer interval;

    private SamplingTargetDocument(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.fixedRate = builder.fixedRate;
        this.reservoirQuota = builder.reservoirQuota;
        this.reservoirQuotaTTL = builder.reservoirQuotaTTL;
        this.interval = builder.interval;
    }

    /**
     * <p>
     * The name of the sampling rule.
     * </p>
     * 
     * @return The name of the sampling rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     * </p>
     * 
     * @return The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    public final Double fixedRate() {
        return fixedRate;
    }

    /**
     * <p>
     * The number of requests per second that X-Ray allocated for this service.
     * </p>
     * 
     * @return The number of requests per second that X-Ray allocated for this service.
     */
    public final Integer reservoirQuota() {
        return reservoirQuota;
    }

    /**
     * <p>
     * When the reservoir quota expires.
     * </p>
     * 
     * @return When the reservoir quota expires.
     */
    public final Instant reservoirQuotaTTL() {
        return reservoirQuotaTTL;
    }

    /**
     * <p>
     * The number of seconds for the service to wait before getting sampling targets again.
     * </p>
     * 
     * @return The number of seconds for the service to wait before getting sampling targets again.
     */
    public final Integer interval() {
        return interval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(fixedRate());
        hashCode = 31 * hashCode + Objects.hashCode(reservoirQuota());
        hashCode = 31 * hashCode + Objects.hashCode(reservoirQuotaTTL());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamplingTargetDocument)) {
            return false;
        }
        SamplingTargetDocument other = (SamplingTargetDocument) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(fixedRate(), other.fixedRate())
                && Objects.equals(reservoirQuota(), other.reservoirQuota())
                && Objects.equals(reservoirQuotaTTL(), other.reservoirQuotaTTL()) && Objects.equals(interval(), other.interval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamplingTargetDocument").add("RuleName", ruleName()).add("FixedRate", fixedRate())
                .add("ReservoirQuota", reservoirQuota()).add("ReservoirQuotaTTL", reservoirQuotaTTL())
                .add("Interval", interval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "FixedRate":
            return Optional.ofNullable(clazz.cast(fixedRate()));
        case "ReservoirQuota":
            return Optional.ofNullable(clazz.cast(reservoirQuota()));
        case "ReservoirQuotaTTL":
            return Optional.ofNullable(clazz.cast(reservoirQuotaTTL()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SamplingTargetDocument, T> g) {
        return obj -> g.apply((SamplingTargetDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamplingTargetDocument> {
        /**
         * <p>
         * The name of the sampling rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the sampling rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The percentage of matching requests to instrument, after the reservoir is exhausted.
         * </p>
         * 
         * @param fixedRate
         *        The percentage of matching requests to instrument, after the reservoir is exhausted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedRate(Double fixedRate);

        /**
         * <p>
         * The number of requests per second that X-Ray allocated for this service.
         * </p>
         * 
         * @param reservoirQuota
         *        The number of requests per second that X-Ray allocated for this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservoirQuota(Integer reservoirQuota);

        /**
         * <p>
         * When the reservoir quota expires.
         * </p>
         * 
         * @param reservoirQuotaTTL
         *        When the reservoir quota expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservoirQuotaTTL(Instant reservoirQuotaTTL);

        /**
         * <p>
         * The number of seconds for the service to wait before getting sampling targets again.
         * </p>
         * 
         * @param interval
         *        The number of seconds for the service to wait before getting sampling targets again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private Double fixedRate;

        private Integer reservoirQuota;

        private Instant reservoirQuotaTTL;

        private Integer interval;

        private BuilderImpl() {
        }

        private BuilderImpl(SamplingTargetDocument model) {
            ruleName(model.ruleName);
            fixedRate(model.fixedRate);
            reservoirQuota(model.reservoirQuota);
            reservoirQuotaTTL(model.reservoirQuotaTTL);
            interval(model.interval);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        @Transient
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Double getFixedRate() {
            return fixedRate;
        }

        public final void setFixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
        }

        @Override
        @Transient
        public final Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public final Integer getReservoirQuota() {
            return reservoirQuota;
        }

        public final void setReservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
        }

        @Override
        @Transient
        public final Builder reservoirQuota(Integer reservoirQuota) {
            this.reservoirQuota = reservoirQuota;
            return this;
        }

        public final Instant getReservoirQuotaTTL() {
            return reservoirQuotaTTL;
        }

        public final void setReservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
        }

        @Override
        @Transient
        public final Builder reservoirQuotaTTL(Instant reservoirQuotaTTL) {
            this.reservoirQuotaTTL = reservoirQuotaTTL;
            return this;
        }

        public final Integer getInterval() {
            return interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        @Transient
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public SamplingTargetDocument build() {
            return new SamplingTargetDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
