/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayAsyncClient;
import software.amazon.awssdk.services.xray.model.GetInsightEventsRequest;
import software.amazon.awssdk.services.xray.model.GetInsightEventsResponse;

public class GetInsightEventsPublisher
implements SdkPublisher<GetInsightEventsResponse> {
    private final XRayAsyncClient client;
    private final GetInsightEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInsightEventsPublisher(XRayAsyncClient client, GetInsightEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInsightEventsPublisher(XRayAsyncClient client, GetInsightEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInsightEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInsightEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetInsightEventsResponseFetcher
    implements AsyncPageFetcher<GetInsightEventsResponse> {
        private GetInsightEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInsightEventsResponse> nextPage(GetInsightEventsResponse previousPage) {
            if (previousPage == null) {
                return GetInsightEventsPublisher.this.client.getInsightEvents(GetInsightEventsPublisher.this.firstRequest);
            }
            return GetInsightEventsPublisher.this.client.getInsightEvents((GetInsightEventsRequest)((Object)GetInsightEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

